/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SetRequestHostHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public SetRequestHostHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("host");
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){
            final /* synthetic */ SetRequestHostHeaderGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                String value = ServerWebExchangeUtils.expand(exchange, config.getHost());
                ServerHttpRequest request = exchange.getRequest().mutate().headers(httpHeaders -> {
                    httpHeaders.remove("Host");
                    httpHeaders.add("Host", value);
                }).build();
                exchange.getAttributes().put(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, true);
                return chain.filter(exchange.mutate().request(request).build());
            }

            public String toString() {
                String host = config.getHost();
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append((Object)(host != null ? host : "")).toString();
            }
        };
    }

    public static class Config {
        private @Nullable String host;

        public @Nullable String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }
    }
}

