/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersProperties;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SecureHeadersGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String X_XSS_PROTECTION_HEADER = "X-Xss-Protection";
    public static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    public static final String X_FRAME_OPTIONS_HEADER = "X-Frame-Options";
    public static final String X_CONTENT_TYPE_OPTIONS_HEADER = "X-Content-Type-Options";
    public static final String REFERRER_POLICY_HEADER = "Referrer-Policy";
    public static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    public static final String X_DOWNLOAD_OPTIONS_HEADER = "X-Download-Options";
    public static final String X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER = "X-Permitted-Cross-Domain-Policies";
    private final SecureHeadersProperties properties;

    public SecureHeadersGatewayFilterFactory(SecureHeadersProperties properties) {
        super(Config.class);
        this.properties = properties;
    }

    @Override
    public GatewayFilter apply(final Config originalConfig) {
        return new GatewayFilter(){
            final /* synthetic */ SecureHeadersGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                HttpHeaders responseHeaders = exchange.getResponse().getHeaders();
                Set<String> headersToAddToResponse = this.this$0.assembleHeaders(originalConfig, this.this$0.properties);
                Config config = originalConfig.withDefaults(this.this$0.properties);
                return chain.filter(exchange).then(Mono.fromRunnable(() -> this.this$0.applySecurityHeaders(responseHeaders, headersToAddToResponse, config)));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).toString();
            }
        };
    }

    private void applySecurityHeaders(HttpHeaders responseHeaders, Set<String> headersToAddToResponse, Config config) {
        String routePermissionPolicyHeaderValue;
        this.addHeaderIfEnabled(responseHeaders, headersToAddToResponse, X_XSS_PROTECTION_HEADER, config.getXssProtectionHeaderValue());
        this.addHeaderIfEnabled(responseHeaders, headersToAddToResponse, STRICT_TRANSPORT_SECURITY_HEADER, config.getStrictTransportSecurityHeaderValue());
        this.addHeaderIfEnabled(responseHeaders, headersToAddToResponse, X_FRAME_OPTIONS_HEADER, config.getFrameOptionsHeaderValue());
        this.addHeaderIfEnabled(responseHeaders, headersToAddToResponse, X_CONTENT_TYPE_OPTIONS_HEADER, config.getContentTypeOptionsHeaderValue());
        this.addHeaderIfEnabled(responseHeaders, headersToAddToResponse, REFERRER_POLICY_HEADER, config.getReferrerPolicyHeaderValue());
        this.addHeaderIfEnabled(responseHeaders, headersToAddToResponse, CONTENT_SECURITY_POLICY_HEADER, config.getContentSecurityPolicyHeaderValue());
        this.addHeaderIfEnabled(responseHeaders, headersToAddToResponse, X_DOWNLOAD_OPTIONS_HEADER, config.getDownloadOptionsHeaderValue());
        this.addHeaderIfEnabled(responseHeaders, headersToAddToResponse, X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER, config.getPermittedCrossDomainPoliciesHeaderValue());
        String permissionPolicyHeaderValue = config.getPermissionPolicyHeaderValue();
        if (config.isRouteFilterConfigProvided() && (routePermissionPolicyHeaderValue = config.getRoutePermissionsPolicyHeaderValue()) != null) {
            permissionPolicyHeaderValue = routePermissionPolicyHeaderValue;
        }
        this.addHeaderIfEnabled(responseHeaders, headersToAddToResponse, "Permissions-Policy", permissionPolicyHeaderValue);
    }

    private Set<String> assembleHeaders(Config config, SecureHeadersProperties properties) {
        HashSet<String> headersToAddToResponse = new HashSet<String>(properties.getDefaultHeaders());
        if (config.isRouteFilterConfigProvided()) {
            headersToAddToResponse.addAll(config.getRouteEnabledHeaders());
            headersToAddToResponse.removeAll(config.getRouteDisabledHeaders());
        } else {
            headersToAddToResponse.addAll(properties.getEnabledHeaders());
            headersToAddToResponse.removeAll(properties.getDisabledHeaders());
        }
        return headersToAddToResponse;
    }

    private void addHeaderIfEnabled(HttpHeaders headers, Set<String> headersToAdd, String headerName, @Nullable String headerValue) {
        if (headerValue != null && headersToAdd.contains(headerName.toLowerCase(Locale.ROOT)) && !headers.containsHeader(headerName)) {
            headers.add(headerName, headerValue);
        }
    }

    public static class Config {
        private Set<String> routeEnabledHeaders = new HashSet<String>();
        private Set<String> routeDisabledHeaders = new HashSet<String>();
        private @Nullable String routePermissionsPolicyHeaderValue;
        private boolean routeFilterConfigProvided;
        private @Nullable String xssProtectionHeaderValue;
        private @Nullable String strictTransportSecurityHeaderValue;
        private @Nullable String frameOptionsHeaderValue;
        private @Nullable String contentTypeOptionsHeaderValue;
        private @Nullable String referrerPolicyHeaderValue;
        private @Nullable String contentSecurityPolicyHeaderValue;
        private @Nullable String downloadOptionsHeaderValue;
        private @Nullable String permittedCrossDomainPoliciesHeaderValue;
        private @Nullable String permissionPolicyHeaderValue;

        public Config withDefaults(SecureHeadersProperties properties) {
            Config config = new Config();
            config.setEnable(this.routeEnabledHeaders);
            config.setDisable(this.routeDisabledHeaders);
            config.setPermissionsPolicy(this.routePermissionsPolicyHeaderValue);
            config.setXssProtectionHeaderValue(this.xssProtectionHeaderValue);
            config.setStrictTransportSecurityHeaderValue(this.strictTransportSecurityHeaderValue);
            config.setFrameOptionsHeaderValue(this.frameOptionsHeaderValue);
            config.setContentTypeOptionsHeaderValue(this.contentTypeOptionsHeaderValue);
            config.setReferrerPolicyHeaderValue(this.referrerPolicyHeaderValue);
            config.setContentSecurityPolicyHeaderValue(this.contentSecurityPolicyHeaderValue);
            config.setDownloadOptionsHeaderValue(this.downloadOptionsHeaderValue);
            config.setPermittedCrossDomainPoliciesHeaderValue(this.permittedCrossDomainPoliciesHeaderValue);
            config.setPermissionPolicyHeaderValue(this.permissionPolicyHeaderValue);
            if (config.xssProtectionHeaderValue == null) {
                config.xssProtectionHeaderValue = properties.getXssProtectionHeader();
            }
            if (config.strictTransportSecurityHeaderValue == null) {
                config.strictTransportSecurityHeaderValue = properties.getStrictTransportSecurity();
            }
            if (config.frameOptionsHeaderValue == null) {
                config.frameOptionsHeaderValue = properties.getFrameOptions();
            }
            if (config.contentTypeOptionsHeaderValue == null) {
                config.contentTypeOptionsHeaderValue = properties.getContentTypeOptions();
            }
            if (config.referrerPolicyHeaderValue == null) {
                config.referrerPolicyHeaderValue = properties.getReferrerPolicy();
            }
            if (config.contentSecurityPolicyHeaderValue == null) {
                config.contentSecurityPolicyHeaderValue = properties.getContentSecurityPolicy();
            }
            if (config.downloadOptionsHeaderValue == null) {
                config.downloadOptionsHeaderValue = properties.getDownloadOptions();
            }
            if (config.permittedCrossDomainPoliciesHeaderValue == null) {
                config.permittedCrossDomainPoliciesHeaderValue = properties.getPermittedCrossDomainPolicies();
            }
            if (config.permissionPolicyHeaderValue == null) {
                config.permissionPolicyHeaderValue = properties.getPermissionsPolicy();
            }
            return config;
        }

        public @Nullable String getXssProtectionHeaderValue() {
            return this.xssProtectionHeaderValue;
        }

        public void setXssProtectionHeaderValue(@Nullable String xssProtectionHeaderHeaderValue) {
            this.xssProtectionHeaderValue = xssProtectionHeaderHeaderValue;
        }

        public @Nullable String getStrictTransportSecurityHeaderValue() {
            return this.strictTransportSecurityHeaderValue;
        }

        public void setStrictTransportSecurityHeaderValue(@Nullable String strictTransportSecurityHeaderValue) {
            this.strictTransportSecurityHeaderValue = strictTransportSecurityHeaderValue;
        }

        public @Nullable String getFrameOptionsHeaderValue() {
            return this.frameOptionsHeaderValue;
        }

        public void setFrameOptionsHeaderValue(@Nullable String frameOptionsHeaderValue) {
            this.frameOptionsHeaderValue = frameOptionsHeaderValue;
        }

        public @Nullable String getContentTypeOptionsHeaderValue() {
            return this.contentTypeOptionsHeaderValue;
        }

        public void setContentTypeOptionsHeaderValue(@Nullable String contentTypeOptionsHeaderValue) {
            this.contentTypeOptionsHeaderValue = contentTypeOptionsHeaderValue;
        }

        public @Nullable String getReferrerPolicyHeaderValue() {
            return this.referrerPolicyHeaderValue;
        }

        public void setReferrerPolicyHeaderValue(@Nullable String referrerPolicyHeaderValue) {
            this.referrerPolicyHeaderValue = referrerPolicyHeaderValue;
        }

        public @Nullable String getContentSecurityPolicyHeaderValue() {
            return this.contentSecurityPolicyHeaderValue;
        }

        public void setContentSecurityPolicyHeaderValue(@Nullable String contentSecurityPolicyHeaderValue) {
            this.contentSecurityPolicyHeaderValue = contentSecurityPolicyHeaderValue;
        }

        public @Nullable String getDownloadOptionsHeaderValue() {
            return this.downloadOptionsHeaderValue;
        }

        public void setDownloadOptionsHeaderValue(@Nullable String downloadOptionHeaderValue) {
            this.downloadOptionsHeaderValue = downloadOptionHeaderValue;
        }

        public @Nullable String getPermittedCrossDomainPoliciesHeaderValue() {
            return this.permittedCrossDomainPoliciesHeaderValue;
        }

        public void setPermittedCrossDomainPoliciesHeaderValue(@Nullable String permittedCrossDomainPoliciesHeaderValue) {
            this.permittedCrossDomainPoliciesHeaderValue = permittedCrossDomainPoliciesHeaderValue;
        }

        public @Nullable String getPermissionPolicyHeaderValue() {
            return this.permissionPolicyHeaderValue;
        }

        public void setPermissionPolicyHeaderValue(@Nullable String permissionPolicyHeaderValue) {
            this.permissionPolicyHeaderValue = permissionPolicyHeaderValue;
        }

        void setEnable(Set<String> enable) {
            if (enable != null) {
                this.routeFilterConfigProvided = true;
                this.routeEnabledHeaders = enable.stream().map(String::toLowerCase).collect(Collectors.toUnmodifiableSet());
            }
        }

        Set<String> getRouteEnabledHeaders() {
            return this.routeEnabledHeaders;
        }

        void setDisable(Set<String> disable) {
            if (disable != null) {
                this.routeFilterConfigProvided = true;
                this.routeDisabledHeaders = disable.stream().map(String::toLowerCase).collect(Collectors.toUnmodifiableSet());
            }
        }

        Set<String> getRouteDisabledHeaders() {
            return this.routeDisabledHeaders;
        }

        protected @Nullable String getRoutePermissionsPolicyHeaderValue() {
            return this.routePermissionsPolicyHeaderValue;
        }

        void setPermissionsPolicy(@Nullable String permissionsPolicy) {
            this.routeFilterConfigProvided = true;
            this.routePermissionsPolicyHeaderValue = permissionsPolicy;
        }

        boolean isRouteFilterConfigProvided() {
            return this.routeFilterConfigProvided;
        }
    }
}

