/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RewriteLocationResponseHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private static final String STRIP_VERSION_KEY = "stripVersion";
    private static final String LOCATION_HEADER_NAME_KEY = "locationHeaderName";
    private static final String HOST_VALUE_KEY = "hostValue";
    private static final String PROTOCOLS_KEY = "protocols";
    private static final Pattern VERSIONED_PATH = Pattern.compile("^/v\\d+/.*");
    private static final String DEFAULT_PROTOCOLS = "https?|ftps?";
    private static final Pattern DEFAULT_HOST_PORT = RewriteLocationResponseHeaderGatewayFilterFactory.compileHostPortPattern("https?|ftps?");
    private static final Pattern DEFAULT_HOST_PORT_VERSION = RewriteLocationResponseHeaderGatewayFilterFactory.compileHostPortVersionPattern("https?|ftps?");

    public RewriteLocationResponseHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    private static Pattern compileHostPortPattern(String protocols) {
        return Pattern.compile("(?<=^(?:" + protocols + ")://)[^:/]+(?::\\d+)?(?=/)");
    }

    private static Pattern compileHostPortVersionPattern(String protocols) {
        return Pattern.compile("(?<=^(?:" + protocols + ")://)[^:/]+(?::\\d+)?(?:/v\\d+)?(?=/)");
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(STRIP_VERSION_KEY, LOCATION_HEADER_NAME_KEY, HOST_VALUE_KEY, PROTOCOLS_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){
            final /* synthetic */ RewriteLocationResponseHeaderGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return chain.filter(exchange).then(Mono.fromRunnable(() -> this.this$0.rewriteLocation(exchange, config)));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append(RewriteLocationResponseHeaderGatewayFilterFactory.STRIP_VERSION_KEY, (Object)config.stripVersion).append(RewriteLocationResponseHeaderGatewayFilterFactory.LOCATION_HEADER_NAME_KEY, (Object)config.locationHeaderName).append(RewriteLocationResponseHeaderGatewayFilterFactory.HOST_VALUE_KEY, (Object)config.hostValue).append(RewriteLocationResponseHeaderGatewayFilterFactory.PROTOCOLS_KEY, (Object)config.protocols).toString();
            }
        };
    }

    void rewriteLocation(ServerWebExchange exchange, Config config) {
        String location = exchange.getResponse().getHeaders().getFirst(config.getLocationHeaderName());
        String host = config.getHostValue() != null ? config.getHostValue() : exchange.getRequest().getHeaders().getFirst("Host");
        String path = exchange.getRequest().getURI().getPath();
        if (location != null && host != null) {
            String fixedLocation = this.fixedLocation(location, host, path, config.getStripVersion(), config.getHostPortPattern(), config.getHostPortVersionPattern());
            exchange.getResponse().getHeaders().set(config.getLocationHeaderName(), fixedLocation);
        }
    }

    String fixedLocation(String location, String host, String path, StripVersion stripVersion, Pattern hostPortPattern, Pattern hostPortVersionPattern) {
        boolean doStrip = StripVersion.ALWAYS_STRIP.equals((Object)stripVersion) || StripVersion.AS_IN_REQUEST.equals((Object)stripVersion) && !VERSIONED_PATH.matcher(path).matches();
        Pattern pattern = doStrip ? hostPortVersionPattern : hostPortPattern;
        return pattern.matcher(location).replaceFirst(host);
    }

    public static class Config {
        private StripVersion stripVersion = StripVersion.AS_IN_REQUEST;
        private String locationHeaderName = "Location";
        private @Nullable String hostValue;
        private String protocols = "https?|ftps?";
        private Pattern hostPortPattern = DEFAULT_HOST_PORT;
        private Pattern hostPortVersionPattern = DEFAULT_HOST_PORT_VERSION;

        public StripVersion getStripVersion() {
            return this.stripVersion;
        }

        public Config setStripVersion(StripVersion stripVersion) {
            this.stripVersion = stripVersion;
            return this;
        }

        public String getLocationHeaderName() {
            return this.locationHeaderName;
        }

        public Config setLocationHeaderName(String locationHeaderName) {
            this.locationHeaderName = locationHeaderName;
            return this;
        }

        public @Nullable String getHostValue() {
            return this.hostValue;
        }

        public Config setHostValue(String hostValue) {
            this.hostValue = hostValue;
            return this;
        }

        public String getProtocols() {
            return this.protocols;
        }

        public Config setProtocols(String protocols) {
            this.protocols = protocols;
            this.hostPortPattern = RewriteLocationResponseHeaderGatewayFilterFactory.compileHostPortPattern(protocols);
            this.hostPortVersionPattern = RewriteLocationResponseHeaderGatewayFilterFactory.compileHostPortVersionPattern(protocols);
            return this;
        }

        public Pattern getHostPortPattern() {
            return this.hostPortPattern;
        }

        public Pattern getHostPortVersionPattern() {
            return this.hostPortVersionPattern;
        }
    }

    public static enum StripVersion {
        NEVER_STRIP,
        AS_IN_REQUEST,
        ALWAYS_STRIP;

    }
}

