/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RemoveResponseHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    public RemoveResponseHeaderGatewayFilterFactory() {
        super(AbstractGatewayFilterFactory.NameConfig.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name");
    }

    @Override
    public GatewayFilter apply(final AbstractGatewayFilterFactory.NameConfig config) {
        return new GatewayFilter(){
            final /* synthetic */ RemoveResponseHeaderGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                String name = Objects.requireNonNull(config.getName(), "name must not be null");
                return chain.filter(exchange).then(Mono.fromRunnable(() -> {
                    if (!exchange.getResponse().isCommitted()) {
                        exchange.getResponse().getHeaders().remove(name);
                    }
                }));
            }

            public String toString() {
                String name = config.getName();
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append("name", (Object)(name != null ? name : "")).toString();
            }
        };
    }
}

