/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.filter.GatewayMetricsFilter;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.context.ApplicationListener;

public class RouteDefinitionMetrics
implements ApplicationListener<RefreshRoutesEvent> {
    private static final Log log = LogFactory.getLog(GatewayMetricsFilter.class);
    private final RouteDefinitionLocator routeLocator;
    private final AtomicInteger routeDefinitionCount;
    private final String metricsPrefix;

    public RouteDefinitionMetrics(MeterRegistry meterRegistry, RouteDefinitionLocator routeLocator, String metricsPrefix) {
        this.routeLocator = routeLocator;
        this.metricsPrefix = metricsPrefix.endsWith(".") ? metricsPrefix.substring(0, metricsPrefix.length() - 1) : metricsPrefix;
        this.routeDefinitionCount = (AtomicInteger)meterRegistry.gauge(this.metricsPrefix + ".routes.count", (Number)new AtomicInteger(0));
    }

    public String getMetricsPrefix() {
        return this.metricsPrefix;
    }

    public void onApplicationEvent(RefreshRoutesEvent event) {
        this.routeLocator.getRouteDefinitions().count().subscribe(count -> {
            this.routeDefinitionCount.set(count.intValue());
            if (log.isDebugEnabled()) {
                log.debug((Object)("New routes count: " + String.valueOf(this.routeDefinitionCount)));
            }
        });
    }
}

