/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractChangeRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;

public class SetRequestUriGatewayFilterFactory
extends AbstractChangeRequestUriGatewayFilterFactory<Config> {
    private static final Logger log = LoggerFactory.getLogger(SetRequestUriGatewayFilterFactory.class);

    public SetRequestUriGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name");
    }

    @Override
    public GatewayFilter apply(final Config config) {
        OrderedGatewayFilter gatewayFilter = (OrderedGatewayFilter)super.apply(config);
        return new OrderedGatewayFilter(this, gatewayFilter, gatewayFilter.getOrder()){
            final /* synthetic */ SetRequestUriGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
                super(delegate, order);
            }

            @Override
            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append("template", (Object)config.getTemplate()).toString();
            }
        };
    }

    String getUri(ServerWebExchange exchange, Config config) {
        String template = config.getTemplate();
        if (template.indexOf(123) == -1) {
            return template;
        }
        Map<String, String> variables = ServerWebExchangeUtils.getUriTemplateVariables(exchange);
        return UriComponentsBuilder.fromUriString((String)template).build().expand(variables).toUriString();
    }

    @Override
    protected Optional<URI> determineRequestUri(ServerWebExchange exchange, Config config) {
        try {
            String url = this.getUri(exchange, config);
            URI uri = URI.create(url);
            if (!uri.isAbsolute()) {
                log.info("Request url is invalid: url={}, error=URI is not absolute", (Object)url);
                return Optional.ofNullable(null);
            }
            return Optional.of(uri);
        }
        catch (IllegalArgumentException e) {
            log.info("Request url is invalid : url={}, error={}", (Object)config.getTemplate(), (Object)e.getMessage());
            return Optional.ofNullable(null);
        }
    }

    public static class Config {
        private String template;

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }
    }
}

