/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class NettyRoutingFilter
implements GlobalFilter,
Ordered {
    public static final int ORDER = Integer.MAX_VALUE;
    private static final Log log = LogFactory.getLog(NettyRoutingFilter.class);
    private final HttpClient httpClient;
    private final ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider;
    private final HttpClientProperties properties;
    private volatile List<HttpHeadersFilter> headersFilters;

    public NettyRoutingFilter(HttpClient httpClient, ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider, HttpClientProperties properties) {
        this.httpClient = httpClient;
        this.headersFiltersProvider = headersFiltersProvider;
        this.properties = properties;
    }

    public List<HttpHeadersFilter> getHeadersFilters() {
        if (this.headersFilters == null) {
            this.headersFilters = (List)this.headersFiltersProvider.getIfAvailable();
        }
        return this.headersFilters;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange) || !"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange);
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().name());
        String url = requestUrl.toASCIIString();
        HttpHeaders filtered = HttpHeadersFilter.filterRequest(this.getHeadersFilters(), exchange);
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        filtered.forEach((arg_0, arg_1) -> ((DefaultHttpHeaders)httpHeaders).set(arg_0, arg_1));
        boolean preserveHost = (Boolean)exchange.getAttributeOrDefault(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, (Object)false);
        Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        Flux responseFlux = this.getHttpClientMono(route, exchange).flatMapMany(httpClient -> ((HttpClient.RequestSender)httpClient.headers(headers -> {
            headers.add((io.netty.handler.codec.http.HttpHeaders)httpHeaders);
            headers.remove("Host");
            if (preserveHost) {
                String host = request.getHeaders().getFirst("Host");
                headers.add("Host", (Object)host);
            }
        }).request(method).uri(url)).send((req, nettyOutbound) -> {
            if (log.isTraceEnabled()) {
                nettyOutbound.withConnection(connection -> log.trace((Object)("outbound route: " + connection.channel().id().asShortText() + ", inbound: " + exchange.getLogPrefix())));
            }
            return nettyOutbound.send((Publisher)request.getBody().map(this::getByteBuf));
        }).responseConnection((res, connection) -> {
            exchange.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR, res);
            exchange.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR, connection);
            ServerHttpResponse response = exchange.getResponse();
            HttpHeaders headers = new HttpHeaders();
            res.responseHeaders().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
            String contentTypeValue = headers.getFirst("Content-Type");
            if (StringUtils.hasLength((String)contentTypeValue)) {
                exchange.getAttributes().put("original_response_content_type", contentTypeValue);
            }
            this.setResponseStatus((HttpClientResponse)res, response);
            HttpHeaders filteredResponseHeaders = HttpHeadersFilter.filter(this.getHeadersFilters(), headers, exchange, HttpHeadersFilter.Type.RESPONSE);
            if (!filteredResponseHeaders.containsHeader("Transfer-Encoding") && filteredResponseHeaders.containsHeader("Content-Length")) {
                response.getHeaders().remove("Transfer-Encoding");
            }
            exchange.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_HEADER_NAMES, filteredResponseHeaders.headerNames());
            response.getHeaders().addAll(filteredResponseHeaders);
            return Mono.just((Object)res);
        }));
        Duration responseTimeout = this.getResponseTimeout(route);
        if (responseTimeout != null) {
            responseFlux = responseFlux.timeout(responseTimeout, (Publisher)Mono.defer(() -> Mono.error((Throwable)new TimeoutException("Response took longer than timeout: " + responseTimeout)))).onErrorMap(TimeoutException.class, th -> new ResponseStatusException((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT, th.getMessage(), (Throwable)th));
        }
        return responseFlux.then(chain.filter(exchange));
    }

    protected ByteBuf getByteBuf(DataBuffer dataBuffer) {
        if (dataBuffer instanceof NettyDataBuffer) {
            NettyDataBuffer buffer = (NettyDataBuffer)dataBuffer;
            return buffer.getNativeBuffer();
        }
        if (dataBuffer instanceof DefaultDataBuffer) {
            DefaultDataBuffer buffer = (DefaultDataBuffer)dataBuffer;
            return Unpooled.wrappedBuffer((ByteBuffer)buffer.getNativeBuffer());
        }
        throw new IllegalArgumentException("Unable to handle DataBuffer of type " + dataBuffer.getClass());
    }

    private void setResponseStatus(HttpClientResponse clientResponse, ServerHttpResponse response) {
        HttpStatus status = HttpStatus.resolve((int)clientResponse.status().code());
        if (status != null) {
            response.setStatusCode((HttpStatusCode)status);
        } else {
            while (response instanceof ServerHttpResponseDecorator) {
                response = ((ServerHttpResponseDecorator)response).getDelegate();
            }
            if (response instanceof AbstractServerHttpResponse) {
                ((AbstractServerHttpResponse)response).setRawStatusCode(Integer.valueOf(clientResponse.status().code()));
            } else {
                throw new IllegalStateException("Unable to set status code " + clientResponse.status().code() + " on response of type " + response.getClass().getName());
            }
        }
    }

    protected Mono<HttpClient> getHttpClientMono(Route route, ServerWebExchange exchange) {
        return Mono.just((Object)this.getHttpClient(route, exchange));
    }

    protected HttpClient getHttpClient(Route route, ServerWebExchange exchange) {
        Object connectTimeoutAttr;
        Object object = connectTimeoutAttr = route.getMetadata().get("connect-timeout") != null ? route.getMetadata().get("connect-timeout") : this.properties.getConnectTimeout();
        if (connectTimeoutAttr != null) {
            Integer connectTimeout = NettyRoutingFilter.getInteger(connectTimeoutAttr);
            return (HttpClient)this.httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
        }
        return this.httpClient;
    }

    static Integer getInteger(Object connectTimeoutAttr) {
        Integer connectTimeout = connectTimeoutAttr instanceof Integer ? (Integer)connectTimeoutAttr : Integer.valueOf(Integer.parseInt(connectTimeoutAttr.toString()));
        return connectTimeout;
    }

    private Duration getResponseTimeout(Route route) {
        try {
            if (route.getMetadata().containsKey("response-timeout")) {
                Long routeResponseTimeout = NettyRoutingFilter.getLong(route.getMetadata().get("response-timeout"));
                if (routeResponseTimeout != null && routeResponseTimeout >= 0L) {
                    return Duration.ofMillis(routeResponseTimeout);
                }
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.properties.getResponseTimeout();
    }

    static Long getLong(Object responseTimeoutAttr) {
        Long responseTimeout = null;
        if (responseTimeoutAttr instanceof Number) {
            responseTimeout = ((Number)responseTimeoutAttr).longValue();
        } else if (responseTimeoutAttr != null) {
            responseTimeout = Long.parseLong(responseTimeoutAttr.toString());
        }
        return responseTimeout;
    }
}

