/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.invoke.reflect;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class OperationMethodParameter
implements OperationParameter {
    private static final boolean jsr305Present = ClassUtils.isPresent((String)"jakarta.annotation.Nonnull", null);
    private final String name;
    private final Parameter parameter;

    OperationMethodParameter(String name, Parameter parameter) {
        this.name = name;
        this.parameter = parameter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.parameter.getType();
    }

    @Override
    public boolean isMandatory() {
        if (!ObjectUtils.isEmpty((Object[])this.parameter.getAnnotationsByType(Nullable.class))) {
            return false;
        }
        return jsr305Present ? new Jsr305().isMandatory(this.parameter) : true;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.parameter.getAnnotation(annotation);
    }

    public String toString() {
        return this.name + " of type " + this.parameter.getType().getName();
    }

    private static class Jsr305 {
        private Jsr305() {
        }

        boolean isMandatory(Parameter parameter) {
            MergedAnnotation annotation = MergedAnnotations.from((AnnotatedElement)parameter).get(Nonnull.class);
            return !annotation.isPresent();
        }
    }
}

