/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.config;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.MediaType;

@ConfigurationProperties(value="spring.cloud.gateway.server.webmvc")
public class GatewayMvcProperties {
    public static final String PREFIX = "spring.cloud.gateway.server.webmvc";
    @NotNull
    @Valid
    private List<RouteProperties> routes = new ArrayList<RouteProperties>();
    @NotNull
    @Valid
    private LinkedHashMap<String, RouteProperties> routesMap = new LinkedHashMap();
    private HttpClient httpClient = new HttpClient();
    private List<MediaType> streamingMediaTypes = Arrays.asList(MediaType.TEXT_EVENT_STREAM, new MediaType("application", "stream+json"), new MediaType("application", "grpc"), new MediaType("application", "grpc+protobuf"), new MediaType("application", "grpc+json"));
    private int streamingBufferSize = 16384;
    private String trustedProxies;

    public List<RouteProperties> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteProperties> routes) {
        this.routes = routes;
    }

    public LinkedHashMap<String, RouteProperties> getRoutesMap() {
        return this.routesMap;
    }

    public void setRoutesMap(LinkedHashMap<String, RouteProperties> routesMap) {
        this.routesMap = routesMap;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public List<MediaType> getStreamingMediaTypes() {
        return this.streamingMediaTypes;
    }

    public void setStreamingMediaTypes(List<MediaType> streamingMediaTypes) {
        this.streamingMediaTypes = streamingMediaTypes;
    }

    public int getStreamingBufferSize() {
        return this.streamingBufferSize;
    }

    public void setStreamingBufferSize(int streamingBufferSize) {
        this.streamingBufferSize = streamingBufferSize;
    }

    public String getTrustedProxies() {
        return this.trustedProxies;
    }

    public void setTrustedProxies(String trustedProxies) {
        this.trustedProxies = trustedProxies;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("httpClient", (Object)this.httpClient).append("routes", this.routes).append("routesMap", this.routesMap).append("streamingMediaTypes", this.streamingMediaTypes).append("streamingBufferSize", this.streamingBufferSize).append("trustedProxies", (Object)this.trustedProxies).toString();
    }

    @Deprecated
    public static class HttpClient {
        private Duration connectTimeout;
        private Duration readTimeout;
        private String sslBundle;
        private HttpClientType type = HttpClientType.JDK;

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="spring.http.client.connect-timeout", since="4.2.0")
        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="spring.http.client.read-timeout", since="4.2.0")
        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="spring.http.client.ssl.bundle", since="4.2.0")
        public String getSslBundle() {
            return this.sslBundle;
        }

        public void setSslBundle(String sslBundle) {
            this.sslBundle = sslBundle;
        }

        @Deprecated
        public HttpClientType getType() {
            return this.type;
        }

        public void setType(HttpClientType type) {
            this.type = type;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("connectTimeout", (Object)this.connectTimeout).append("readTimeout", (Object)this.readTimeout).append("sslBundle", (Object)this.sslBundle).append("type", (Object)this.type).toString();
        }
    }

    public static enum HttpClientType {
        JDK,
        AUTODETECT;

    }
}

