/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.boot.origin.TextResourceOrigin;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;

class GatewayServerWebMvcPropertiesMigrationListener
implements ApplicationListener<SpringApplicationEvent> {
    private static final Log logger = LogFactory.getLog(GatewayServerWebMvcPropertiesMigrationListener.class);
    private static final String PROPERTIES_MIGRATOR_CLASS = "org.springframework.boot.context.properties.migrator.PropertiesMigrationListener";
    private static final String DEPRECATED_ROOT = "spring.cloud.gateway.mvc";
    private static final String DEPRECATED_ROUTES_LIST_KEY = "spring.cloud.gateway.mvc.routes";
    private static final String DEPRECATED_ROUTES_MAP_KEY = "spring.cloud.gateway.mvc.routes-map";
    private static final String DEPRECATED_ROUTESMAP_KEY = "spring.cloud.gateway.mvc.routesMap";
    private static final String GATEWAY_PROPERTY_SOURCE_PREFIX = "migrategatewaymvc";
    private static final String NEW_ROUTES_LIST_KEY = "spring.cloud.gateway.server.webmvc.routes";
    private static final String NEW_ROUTES_MAP_KEY = "spring.cloud.gateway.server.webmvc.routes-map";
    private final List<Migration> routesMigrations = new ArrayList<Migration>();

    GatewayServerWebMvcPropertiesMigrationListener() {
    }

    public void onApplicationEvent(SpringApplicationEvent event) {
        if (!ClassUtils.isPresent((String)PROPERTIES_MIGRATOR_CLASS, null)) {
            return;
        }
        if (event instanceof ApplicationPreparedEvent) {
            ApplicationPreparedEvent preparedEvent = (ApplicationPreparedEvent)event;
            this.onApplicationPreparedEvent(preparedEvent);
        }
        if (event instanceof ApplicationReadyEvent || event instanceof ApplicationFailedEvent) {
            this.logLegacyPropertiesReport();
        }
    }

    private void onApplicationPreparedEvent(ApplicationPreparedEvent event) {
        ConfigurableEnvironment env = event.getApplicationContext().getEnvironment();
        ConfigurationPropertySources.get((Environment)env).forEach(propertySource -> {
            this.routesMigrations.addAll(this.migrate(env, (ConfigurationPropertySource)propertySource, "migrategatewaymvcroutes-", DEPRECATED_ROUTES_LIST_KEY, NEW_ROUTES_LIST_KEY));
            this.routesMigrations.addAll(this.migrate(env, (ConfigurationPropertySource)propertySource, "migrategatewaymvcroutes-map-", DEPRECATED_ROUTES_MAP_KEY, NEW_ROUTES_MAP_KEY));
            this.routesMigrations.addAll(this.migrate(env, (ConfigurationPropertySource)propertySource, "migrategatewaymvcroutesMap-", DEPRECATED_ROUTES_MAP_KEY, NEW_ROUTES_MAP_KEY));
        });
    }

    private List<Migration> migrate(ConfigurableEnvironment env, ConfigurationPropertySource propertySource, String propertySourcePrefix, String deprecatedKey, String newKeyPrefix) {
        ConfigurationPropertyName routesParentName;
        IterableConfigurationPropertySource iterableSource;
        List matchingConfigProps;
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        if (propertySource instanceof IterableConfigurationPropertySource && !(matchingConfigProps = (iterableSource = (IterableConfigurationPropertySource)propertySource).filter(arg_0 -> GatewayServerWebMvcPropertiesMigrationListener.lambda$migrate$1(routesParentName = ConfigurationPropertyName.of((CharSequence)deprecatedKey), arg_0)).stream().toList()).isEmpty()) {
            String originalPropertySourceName;
            Object object = propertySource.getUnderlyingSource();
            if (object instanceof PropertySource) {
                PropertySource underlyingSource = (PropertySource)object;
                originalPropertySourceName = underlyingSource.getName();
            } else {
                originalPropertySourceName = propertySource.getUnderlyingSource().toString();
            }
            String newPropertySourceName = propertySourcePrefix + originalPropertySourceName;
            LinkedHashMap<String, OriginTrackedValue> content = new LinkedHashMap<String, OriginTrackedValue>();
            for (ConfigurationPropertyName originalPropertyName : matchingConfigProps) {
                ConfigurationPropertyName suffix = originalPropertyName.subName(routesParentName.getNumberOfElements());
                ConfigurationPropertyName newProperty = ConfigurationPropertyName.of((CharSequence)newKeyPrefix).append(suffix);
                ConfigurationProperty configurationProperty = propertySource.getConfigurationProperty(originalPropertyName);
                Object value = configurationProperty.getValue();
                OriginTrackedValue originTrackedValue = OriginTrackedValue.of((Object)value, (Origin)configurationProperty.getOrigin());
                content.put(newProperty.toString(), originTrackedValue);
                migrations.add(new Migration(originalPropertySourceName, originalPropertyName, configurationProperty, newProperty));
            }
            env.getPropertySources().addBefore(originalPropertySourceName, (PropertySource)new OriginTrackedMapPropertySource(newPropertySourceName, content));
        }
        return migrations;
    }

    private void logLegacyPropertiesReport() {
        if (!this.routesMigrations.isEmpty()) {
            LinkedMultiValueMap content = new LinkedMultiValueMap();
            this.routesMigrations.forEach(migration -> content.add((Object)migration.originalPropertySourceName(), migration));
            StringBuilder report = new StringBuilder();
            report.append(String.format("%nThe use of configuration keys that have been renamed was found in the environment:%n%n", new Object[0]));
            content.forEach((name, properties) -> {
                report.append(String.format("Property source '%s':%n", name));
                properties.forEach(property -> {
                    ConfigurationPropertyName originalPropertyName = property.originalPropertyName();
                    report.append(String.format("\tKey: %s%n", originalPropertyName));
                    Integer lineNumber = property.determineLineNumber();
                    if (lineNumber != null) {
                        report.append(String.format("\t\tLine: %d%n", lineNumber));
                    }
                    report.append(String.format("\t\tReplacement: %s%n", property.newProperty().toString()));
                });
                report.append(String.format("%n", new Object[0]));
            });
            report.append(String.format("%n", new Object[0]));
            report.append("Each configuration key has been temporarily mapped to its replacement for your convenience. To silence this warning, please update your configuration to use the new keys.");
            report.append(String.format("%n", new Object[0]));
            logger.warn((Object)report.toString());
        }
    }

    private static /* synthetic */ boolean lambda$migrate$1(ConfigurationPropertyName routesParentName, ConfigurationPropertyName n) {
        if (n.getNumberOfElements() < routesParentName.getNumberOfElements()) {
            return false;
        }
        ConfigurationPropertyName chop = n.chop(routesParentName.getNumberOfElements());
        return routesParentName.equals((Object)chop);
    }

    private record Migration(String originalPropertySourceName, ConfigurationPropertyName originalPropertyName, ConfigurationProperty originalProperty, ConfigurationPropertyName newProperty) {
        private Integer determineLineNumber() {
            TextResourceOrigin textOrigin;
            Origin origin = this.originalProperty.getOrigin();
            if (origin instanceof PropertySourceOrigin) {
                PropertySourceOrigin propertySourceOrigin = (PropertySourceOrigin)origin;
                origin = propertySourceOrigin.getOrigin();
            }
            if (origin instanceof TextResourceOrigin && (textOrigin = (TextResourceOrigin)origin).getLocation() != null) {
                return textOrigin.getLocation().getLine() + 1;
            }
            return null;
        }
    }
}

