/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import org.springframework.web.util.UriBuilder;

public abstract class BodyFilterFunctions {
    private BodyFilterFunctions() {
    }

    public static Function<ServerRequest, ServerRequest> adaptCachedBody() {
        return request -> {
            Object o = MvcUtils.getAttribute(request, MvcUtils.CACHED_REQUEST_BODY_ATTR);
            if (o instanceof ByteArrayInputStream) {
                ByteArrayInputStream body = (ByteArrayInputStream)o;
                return BodyFilterFunctions.wrapRequest(request, body);
            }
            return request;
        };
    }

    private static ServerRequestWrapper wrapRequest(ServerRequest request, byte[] body) {
        return BodyFilterFunctions.wrapRequest(request, new ByteArrayInputStream(body));
    }

    private static ServerRequestWrapper wrapRequest(ServerRequest request, ByteArrayInputStream body) {
        final ByteArrayServletInputStream inputStream = new ByteArrayServletInputStream(body);
        final HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request.servletRequest()){

            public ServletInputStream getInputStream() {
                return inputStream;
            }
        };
        return new ServerRequestWrapper(request){

            @Override
            public HttpServletRequest servletRequest() {
                return wrapper;
            }
        };
    }

    public static <T, R> Function<ServerRequest, ServerRequest> modifyRequestBody(Class<T> inClass, Class<R> outClass, String newContentType, RewriteFunction<T, R> rewriteFunction) {
        return request -> MvcUtils.cacheAndReadBody(request, inClass).map(body -> {
            Object convertedBody = rewriteFunction.apply(request, body);
            MediaType contentType = StringUtils.hasText((String)newContentType) ? MediaType.parseMediaType((String)newContentType) : (MediaType)request.headers().contentType().orElse(null);
            List httpMessageConverters = request.messageConverters();
            for (HttpMessageConverter messageConverter : httpMessageConverters) {
                if (!messageConverter.canWrite(outClass, contentType)) continue;
                HttpHeaders headers = new HttpHeaders();
                headers.putAll((Map)request.headers().asHttpHeaders());
                headers.remove((Object)"Content-Length");
                if (contentType != null) {
                    headers.setContentType(contentType);
                }
                try {
                    ByteArrayHttpOutputMessage outputMessage = new ByteArrayHttpOutputMessage(headers);
                    messageConverter.write(convertedBody, contentType, (HttpOutputMessage)outputMessage);
                    ServerRequest modified = ServerRequest.from((ServerRequest)request).headers(httpHeaders -> httpHeaders.putAll((Map)headers)).build();
                    return BodyFilterFunctions.wrapRequest(modified, outputMessage.getBytes());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return request;
        }).orElse((ServerRequest)request);
    }

    public static <T, R> BiFunction<ServerRequest, ServerResponse, ServerResponse> modifyResponseBody(Class<T> inClass, Class<R> outClass, String newContentType, RewriteResponseFunction<T, R> rewriteFunction) {
        return (request, response) -> {
            Object o = request.attributes().get(MvcUtils.CLIENT_RESPONSE_INPUT_STREAM_ATTR);
            if (o instanceof InputStream) {
                InputStream inputStream = (InputStream)o;
                try {
                    List converters = request.messageConverters();
                    Optional<HttpMessageConverter> inConverter = converters.stream().filter(c -> c.canRead(inClass, response.headers().getContentType())).findFirst();
                    if (inConverter.isEmpty()) {
                        return response;
                    }
                    HttpMessageConverter inputConverter = inConverter.get();
                    Object input = inputConverter.read(inClass, (HttpInputMessage)new SimpleInputMessage(inputStream, response.headers()));
                    Object output = rewriteFunction.apply((ServerRequest)request, (ServerResponse)response, (Object)input);
                    Optional<HttpMessageConverter> outConverter = converters.stream().filter(c -> c.canWrite(outClass, null)).findFirst();
                    if (outConverter.isEmpty()) {
                        return response;
                    }
                    HttpMessageConverter byteConverter = outConverter.get();
                    ByteArrayHttpOutputMessage outputMessage = new ByteArrayHttpOutputMessage(response.headers());
                    byteConverter.write(output, null, (HttpOutputMessage)outputMessage);
                    request.attributes().put(MvcUtils.CLIENT_RESPONSE_INPUT_STREAM_ATTR, new ByteArrayInputStream(outputMessage.body.toByteArray()));
                    if (StringUtils.hasText((String)newContentType)) {
                        response.headers().setContentType(MediaType.parseMediaType((String)newContentType));
                    }
                    response.headers().remove((Object)"Content-Length");
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return response;
        };
    }

    private static class ServerRequestWrapper
    implements ServerRequest {
        private final ServerRequest delegate;

        protected ServerRequestWrapper(ServerRequest delegate) {
            this.delegate = delegate;
        }

        public <T> T bind(Class<T> bindType) throws BindException {
            return (T)this.delegate.bind(bindType);
        }

        public <T> T bind(Class<T> bindType, Consumer<WebDataBinder> dataBinderCustomizer) throws BindException {
            return (T)this.delegate.bind(bindType, dataBinderCustomizer);
        }

        public HttpMethod method() {
            return this.delegate.method();
        }

        @Deprecated
        public String methodName() {
            return this.delegate.methodName();
        }

        public URI uri() {
            return this.delegate.uri();
        }

        public UriBuilder uriBuilder() {
            return this.delegate.uriBuilder();
        }

        public String path() {
            return this.delegate.path();
        }

        @Deprecated
        public PathContainer pathContainer() {
            return this.delegate.pathContainer();
        }

        public RequestPath requestPath() {
            return this.delegate.requestPath();
        }

        public ServerRequest.Headers headers() {
            return this.delegate.headers();
        }

        public MultiValueMap<String, Cookie> cookies() {
            return this.delegate.cookies();
        }

        public Optional<InetSocketAddress> remoteAddress() {
            return this.delegate.remoteAddress();
        }

        public List<HttpMessageConverter<?>> messageConverters() {
            return this.delegate.messageConverters();
        }

        public <T> T body(Class<T> bodyType) throws ServletException, IOException {
            return (T)this.delegate.body(bodyType);
        }

        public <T> T body(ParameterizedTypeReference<T> bodyType) throws ServletException, IOException {
            return (T)this.delegate.body(bodyType);
        }

        public Optional<Object> attribute(String name) {
            return this.delegate.attribute(name);
        }

        public Map<String, Object> attributes() {
            return this.delegate.attributes();
        }

        public Optional<String> param(String name) {
            return this.delegate.param(name);
        }

        public MultiValueMap<String, String> params() {
            return this.delegate.params();
        }

        public MultiValueMap<String, Part> multipartData() throws IOException, ServletException {
            return this.delegate.multipartData();
        }

        public String pathVariable(String name) {
            return this.delegate.pathVariable(name);
        }

        public Map<String, String> pathVariables() {
            return this.delegate.pathVariables();
        }

        public HttpSession session() {
            return this.delegate.session();
        }

        public Optional<Principal> principal() {
            return this.delegate.principal();
        }

        public HttpServletRequest servletRequest() {
            return this.delegate.servletRequest();
        }

        public Optional<ServerResponse> checkNotModified(Instant lastModified) {
            return this.delegate.checkNotModified(lastModified);
        }

        public Optional<ServerResponse> checkNotModified(String etag) {
            return this.delegate.checkNotModified(etag);
        }

        public Optional<ServerResponse> checkNotModified(Instant lastModified, String etag) {
            return this.delegate.checkNotModified(lastModified, etag);
        }

        public static ServerRequest create(HttpServletRequest servletRequest, List<HttpMessageConverter<?>> messageReaders) {
            return ServerRequest.create((HttpServletRequest)servletRequest, messageReaders);
        }

        public static ServerRequest.Builder from(ServerRequest other) {
            return ServerRequest.from((ServerRequest)other);
        }
    }

    private static class ByteArrayServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream body;

        ByteArrayServletInputStream(ByteArrayInputStream body) {
            body.reset();
            this.body = body;
        }

        public boolean isFinished() {
            return this.body.available() <= 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener listener) {
        }

        public int read() {
            return this.body.read();
        }
    }

    public static interface RewriteFunction<T, R>
    extends BiFunction<ServerRequest, T, R> {
    }

    public static interface RewriteResponseFunction<T, R> {
        public R apply(ServerRequest var1, ServerResponse var2, T var3);
    }

    private static final class SimpleInputMessage
    implements HttpInputMessage {
        private final InputStream inputStream;
        private final HttpHeaders headers;

        private SimpleInputMessage(InputStream inputStream, HttpHeaders headers) {
            this.inputStream = inputStream;
            this.headers = headers;
        }

        public InputStream getBody() throws IOException {
            return this.inputStream;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }

    private static final class ByteArrayHttpOutputMessage
    implements HttpOutputMessage {
        private final HttpHeaders headers;
        private final ByteArrayOutputStream body;

        private ByteArrayHttpOutputMessage(HttpHeaders headers) {
            this.headers = headers;
            this.body = new ByteArrayOutputStream();
        }

        public OutputStream getBody() throws IOException {
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public byte[] getBytes() {
            return this.body.toByteArray();
        }
    }
}

