/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyValues {
    private List<KeyValue> keyValues = new ArrayList<KeyValue>();

    public List<KeyValue> getKeyValues() {
        return this.keyValues;
    }

    public void setKeyValues(List<KeyValue> keyValues) {
        this.keyValues = keyValues;
    }

    public static KeyValues valueOf(String s) {
        String[] tokens = StringUtils.tokenizeToStringArray((String)s, (String)",", (boolean)true, (boolean)true);
        List<KeyValue> parsedKeyValues = Arrays.stream(tokens).map(KeyValue::valueOf).toList();
        KeyValues keyValues = new KeyValues();
        keyValues.setKeyValues(parsedKeyValues);
        return keyValues;
    }

    public static class KeyValue {
        private final String key;
        private final String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("name", (Object)this.key).append("value", (Object)this.value).toString();
        }

        public static KeyValue valueOf(String s) {
            String[] tokens = StringUtils.tokenizeToStringArray((String)s, (String)":", (boolean)true, (boolean)true);
            Assert.isTrue((tokens.length == 2 ? 1 : 0) != 0, () -> "String must be two tokens delimited by colon, but was " + s);
            return new KeyValue(tokens[0], tokens[1]);
        }
    }
}

