/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.mvc.config;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.mvc.ProxyExchange;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ProxyExchangeArgumentResolver
implements HandlerMethodArgumentResolver {
    private final RestTemplate rest;
    private @Nullable HttpHeaders headers;
    private @Nullable Set<String> autoForwardedHeaders;
    private @Nullable Set<String> excluded;

    public ProxyExchangeArgumentResolver(RestTemplate builder) {
        this.rest = builder;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setAutoForwardedHeaders(@Nullable Set<String> autoForwardedHeaders) {
        this.autoForwardedHeaders = autoForwardedHeaders == null ? null : autoForwardedHeaders.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    public void setExcluded(@Nullable Set<String> excluded) {
        this.excluded = excluded;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return ProxyExchange.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        ProxyExchange proxy = new ProxyExchange(this.rest, webRequest, mavContainer, binderFactory, this.type(parameter));
        this.configureHeaders(proxy);
        this.configureAutoForwardedHeaders(proxy, webRequest);
        this.configureExcluded(proxy);
        return proxy;
    }

    private Type type(MethodParameter parameter) {
        Type type = parameter.getGenericParameterType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            type = parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    private HttpHeaders extractAutoForwardedHeaders(NativeWebRequest webRequest) {
        HttpServletRequest nativeRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        Enumeration headerNames = nativeRequest.getHeaderNames();
        HttpHeaders headers = new HttpHeaders();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            if (!this.autoForwardedHeaders.contains(header.toLowerCase(Locale.ROOT))) continue;
            headers.addAll(header, Collections.list(nativeRequest.getHeaders(header)));
        }
        return headers;
    }

    private void configureHeaders(ProxyExchange<?> proxy) {
        if (this.headers != null) {
            proxy.headers(this.headers);
        }
    }

    private void configureAutoForwardedHeaders(ProxyExchange<?> proxy, NativeWebRequest webRequest) {
        if (!CollectionUtils.isEmpty(this.autoForwardedHeaders)) {
            proxy.headers(this.extractAutoForwardedHeaders(webRequest));
        }
    }

    private void configureExcluded(ProxyExchange<?> proxy) {
        if (!CollectionUtils.isEmpty(this.excluded)) {
            proxy.excluded(this.excluded.toArray(new String[0]));
        }
    }
}

