/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.mvc.config;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.cloud.gateway.mvc.config.ProxyExchangeArgumentResolver;
import org.springframework.cloud.gateway.mvc.config.ProxyExchangeWebMvcProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@ConditionalOnClass(value={HandlerMethodReturnValueHandler.class, RestTemplateBuilder.class})
@EnableConfigurationProperties(value={ProxyExchangeWebMvcProperties.class})
public class ProxyResponseAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    private ApplicationContext context;

    @Bean
    @ConditionalOnMissingBean
    public ProxyExchangeArgumentResolver proxyExchangeArgumentResolver(Optional<RestTemplateBuilder> optional, ProxyExchangeWebMvcProperties properties) {
        RestTemplateBuilder builder = optional.orElse(new RestTemplateBuilder(new RestTemplateCustomizer[0]));
        RestTemplate template = builder.build();
        template.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
        template.getMessageConverters().add(new ByteArrayHttpMessageConverter(){

            public boolean supports(Class<?> clazz) {
                return true;
            }
        });
        ProxyExchangeArgumentResolver resolver = new ProxyExchangeArgumentResolver(template);
        resolver.setHeaders(properties.convertHeaders());
        resolver.setAutoForwardedHeaders(properties.getAutoForward());
        HashSet<String> excludedHeaderNames = new HashSet<String>();
        if (properties.getSensitive() != null) {
            excludedHeaderNames.addAll(properties.getSensitive());
        }
        if (properties.getSkipped() != null) {
            excludedHeaderNames.addAll(properties.getSkipped());
        }
        resolver.setExcluded(excludedHeaderNames);
        return resolver;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)this.context.getBean(ProxyExchangeArgumentResolver.class));
    }

    private static class NoOpResponseErrorHandler
    extends DefaultResponseErrorHandler {
        private NoOpResponseErrorHandler() {
        }

        public void handleError(URI url, HttpMethod method, ClientHttpResponse response) throws IOException {
        }

        protected void handleError(ClientHttpResponse response, HttpStatusCode statusCode, @Nullable URI url, @Nullable HttpMethod method) throws IOException {
        }
    }
}

