/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.wrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThinJarWrapper {
    public static final String THIN_ROOT = "thin.root";
    public static final String THIN_LIBRARY = "thin.library";
    public static final String THIN_ARCHIVE = "thin.archive";
    private static final String THIN_SOURCE = "thin.source";
    public static final String THIN_REPO = "thin.repo";
    public static final String THIN_LAUNCHER = "thin.launcher";
    public static final String THIN_DEBUG = "thin.debug";
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    private static final String DEFAULT_LAUNCHER_CLASS = "org.springframework.boot.loader.thin.ThinJarLauncher";
    private static final String DEFAULT_LIBRARY = "org.springframework.boot.experimental:spring-boot-thin-launcher:jar:exec:1.0.31.RELEASE";
    private Properties properties;
    private boolean debug;

    public static void main(String[] args) throws Exception {
        Class<ThinJarWrapper> launcher = ThinJarWrapper.class;
        ThinJarWrapper wrapper = new ThinJarWrapper(args);
        if (wrapper.getProperty(THIN_ARCHIVE) == null) {
            System.setProperty(THIN_ARCHIVE, new File(launcher.getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath());
        }
        wrapper.launch(args);
    }

    ThinJarWrapper(String ... args) {
        this.properties = ThinJarWrapper.properties(args);
        String debug = this.getProperty(THIN_DEBUG);
        this.debug = debug != null && !"false".equals(debug);
    }

    private static Properties properties(String[] args) {
        Properties properties = new Properties();
        for (String arg : args) {
            if (!arg.startsWith("--") || arg.length() <= 2) continue;
            arg = arg.substring(2);
            String[] split = arg.split("=");
            properties.setProperty(split[0].trim(), split.length > 1 ? split[1].trim() : "");
        }
        return properties;
    }

    private void launch(String ... args) throws Exception {
        String target = this.download();
        if (!new File(target).exists()) {
            throw new IllegalStateException("Cannot locate launcher: " + target);
        }
        if (this.debug) {
            System.err.println("Using launcher: " + target);
        }
        ClassLoader classLoader = this.getClassLoader(target);
        String launcherClass = this.launcherClass(target);
        Class<?> launcher = classLoader.loadClass(launcherClass);
        this.findMainMethod(launcher).invoke(null, new Object[]{this.args(launcherClass, args)});
    }

    String download() {
        String library = this.getProperty(THIN_LIBRARY);
        if (library != null && !library.startsWith("maven://")) {
            if (library.startsWith("file:")) {
                if ((library = library.substring("file:".length())).startsWith("//")) {
                    library = library.substring("//".length());
                }
                return library;
            }
            if (library.contains("//")) {
                String parent = this.thinRootRepository();
                String file = "/" + new File(library).getName();
                File target = new File(parent + file);
                this.downloadFromUrl(library, target);
                return parent + file;
            }
            if (library.endsWith(".jar")) {
                return library;
            }
        }
        String file = this.getArtifactPath(this.coordinates(library));
        String parent = this.thinRootRepository();
        File target = new File(parent + file);
        if (!target.exists()) {
            if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                throw new IllegalStateException("Cannot create directory for library at " + target);
            }
            boolean result = false;
            String defaultPath = this.mavenLocal();
            if (!defaultPath.equals(parent)) {
                result = this.downloadFromUrl(this.getUrl(defaultPath) + file, target);
            }
            if (!result) {
                String repo = this.getProperty(THIN_REPO);
                String string = repo != null ? repo : (repo = file.contains("SNAPSHOT") ? "https://repo.spring.io/snapshot" : "https://repo1.maven.org/maven2");
                if (repo.endsWith("/")) {
                    repo = repo.substring(0, repo.length() - 1);
                }
                this.downloadFromUrl(repo + file, target);
            }
        } else if (this.debug) {
            System.err.println("Cached launcher found: " + parent);
        }
        return parent + file;
    }

    private String coordinates(String library) {
        if (library == null) {
            return DEFAULT_LIBRARY;
        }
        if (library.startsWith("maven://")) {
            library = library.substring("maven://".length());
        }
        return library;
    }

    private String[] args(String launcherClass, String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("--thin.library")) continue;
            result.add(arg);
        }
        if (this.getClass().getName().equals(launcherClass)) {
            String archive = this.getProperty(THIN_ARCHIVE);
            if (archive != null) {
                System.setProperty(THIN_SOURCE, archive);
            }
            for (String arg : args) {
                if (!arg.startsWith("--thin.archive")) continue;
                result.remove(arg);
            }
            System.clearProperty(THIN_ARCHIVE);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String launcherClass(String library) {
        String launcher = this.getProperty(THIN_LAUNCHER);
        if (launcher == null) {
            JarFile jar = null;
            try {
                String mainClass;
                jar = new JarFile(library);
                Manifest manifest = jar.getManifest();
                if (manifest != null && (mainClass = manifest.getMainAttributes().getValue("Main-Class")) != null) {
                    String string = mainClass;
                    return string;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return launcher == null ? DEFAULT_LAUNCHER_CLASS : launcher;
    }

    private Method findMainMethod(Class<?> launcher) throws NoSuchMethodException {
        return launcher.getMethod("main", String[].class);
    }

    private ClassLoader getClassLoader(String library) throws Exception {
        URL[] urls = new URL[]{new File(library).toURI().toURL()};
        URLClassLoader classLoader = new URLClassLoader(urls, ThinJarWrapper.class.getClassLoader().getParent());
        Thread.currentThread().setContextClassLoader(classLoader);
        return classLoader;
    }

    String thinRootRepository() {
        String root = this.getProperty(THIN_ROOT);
        if (root == null) {
            return this.mavenLocal();
        }
        return this.mavenLocal(root);
    }

    String mavenLocal() {
        String repo = this.getProperty(MAVEN_REPO_LOCAL);
        if (repo != null) {
            return repo;
        }
        return this.mavenLocal(null);
    }

    private String mavenLocal(String home) {
        return this.mvnHome(home) + "/repository";
    }

    private String mvnHome(String home) {
        if (home != null) {
            return home;
        }
        return this.home() + "/.m2";
    }

    private String home() {
        String home = this.getProperty("user.home");
        return home == null ? "." : home;
    }

    String getProperty(String key) {
        if (this.properties != null && this.properties.getProperty(key) != null) {
            return this.properties.getProperty(key);
        }
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        return System.getenv(key.replace(".", "_").toUpperCase());
    }

    private String get(String value, String defaultValue) {
        return value == null || value.length() <= 0 ? defaultValue : value;
    }

    private String getUrl(String path) {
        File file = new File(path);
        try {
            return file.getCanonicalFile().toURI().toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot locate file: " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFromUrl(String path, File target) {
        if (this.debug) {
            System.err.println("Downloading launcher from: " + path);
        }
        InputStream input = null;
        OutputStream output = null;
        try {
            input = new URL(path).openStream();
            output = new FileOutputStream(target);
            byte[] bytes = new byte[4096];
            int count = input.read(bytes);
            while (count > 0) {
                output.write(bytes, 0, count);
                count = input.read(bytes);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (this.debug) {
                System.err.println("Failed to download: " + path);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private String getArtifactPath(String coordinates) {
        Pattern p = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
        Matcher m = p.matcher(coordinates);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coordinates + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String extension = this.get(m.group(4), "jar");
        String classifier = this.get(m.group(6), null);
        String version = m.group(7);
        return "/" + groupId.replace(".", "/") + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + (classifier != null ? "-" + classifier : "") + "." + extension;
    }
}

