/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.function;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Collections;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.webflux.autoconfigure.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.webflux.error.DefaultErrorAttributes;
import org.springframework.boot.webflux.error.ErrorAttributes;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.config.ContextFunctionCatalogInitializer;
import org.springframework.cloud.function.web.FunctionHttpProperties;
import org.springframework.cloud.function.web.function.FunctionEndpointFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.ClassUtils;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

public class FunctionEndpointInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private static boolean webflux = ClassUtils.isPresent((String)"org.springframework.web.reactive.function.server.RouterFunction", null);

    public void initialize(GenericApplicationContext context) {
        if (webflux && ContextFunctionCatalogInitializer.enabled && context.getEnvironment().getProperty("spring.main.web-application-type", WebApplicationType.class, (Object)WebApplicationType.REACTIVE) == WebApplicationType.REACTIVE && ((Boolean)context.getEnvironment().getProperty("spring.functional.enabled", Boolean.class, (Object)false)).booleanValue()) {
            this.registerEndpoint(context);
            this.registerWebFluxAutoConfiguration(context);
        }
    }

    private void registerWebFluxAutoConfiguration(GenericApplicationContext context) {
        context.registerBean(DefaultErrorWebExceptionHandler.class, () -> this.errorHandler(context), new BeanDefinitionCustomizer[0]);
        context.registerBean("webHandler", HttpWebHandlerAdapter.class, () -> this.httpHandler(context), new BeanDefinitionCustomizer[0]);
        context.addApplicationListener((ApplicationListener)new ServerListener(context));
    }

    private void registerEndpoint(GenericApplicationContext context) {
        context.registerBean(FunctionHttpProperties.class, () -> new FunctionHttpProperties(), new BeanDefinitionCustomizer[0]);
        context.registerBean(FunctionEndpointFactory.class, () -> new FunctionEndpointFactory((FunctionProperties)context.getBean(FunctionProperties.class), (FunctionCatalog)context.getBean(FunctionCatalog.class), (Environment)context.getEnvironment(), (FunctionHttpProperties)context.getBean(FunctionHttpProperties.class)), new BeanDefinitionCustomizer[0]);
        RouterFunctionRegister.register(context);
    }

    private HttpWebHandlerAdapter httpHandler(GenericApplicationContext context) {
        return (HttpWebHandlerAdapter)RouterFunctions.toHttpHandler((RouterFunction)((RouterFunction)context.getBean(RouterFunction.class)), (HandlerStrategies)HandlerStrategies.empty().exceptionHandler((WebExceptionHandler)context.getBeansOfType(WebExceptionHandler.class).values().iterator().next()).codecs(config -> config.registerDefaults(true)).build());
    }

    private DefaultErrorWebExceptionHandler errorHandler(GenericApplicationContext context) {
        context.registerBean(ErrorAttributes.class, () -> new DefaultErrorAttributes(), new BeanDefinitionCustomizer[0]);
        context.registerBean(ErrorProperties.class, () -> new ErrorProperties(), new BeanDefinitionCustomizer[0]);
        context.registerBean(WebProperties.Resources.class, () -> new WebProperties.Resources(), new BeanDefinitionCustomizer[0]);
        DefaultErrorWebExceptionHandler handler = new DefaultErrorWebExceptionHandler((ErrorAttributes)context.getBeansOfType(ErrorAttributes.class).values().iterator().next(), (WebProperties.Resources)context.getBean(WebProperties.Resources.class), (ErrorProperties)context.getBean(ErrorProperties.class), (ApplicationContext)context);
        ServerCodecConfigurer codecs = ServerCodecConfigurer.create();
        handler.setMessageWriters(codecs.getWriters());
        handler.setMessageReaders(codecs.getReaders());
        return handler;
    }

    private static class ServerListener
    implements SmartApplicationListener {
        private static Log logger = LogFactory.getLog(ServerListener.class);
        private GenericApplicationContext context;

        ServerListener(GenericApplicationContext context) {
            this.context = context;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            ApplicationContext context = ((ContextRefreshedEvent)event).getApplicationContext();
            if (context != this.context) {
                return;
            }
            if (!ClassUtils.isPresent((String)"org.springframework.http.server.reactive.HttpHandler", null)) {
                logger.info((Object)"No web server classes found so no server to start");
                return;
            }
            Integer port = Integer.valueOf(context.getEnvironment().resolvePlaceholders("${server.port:${PORT:8080}}"));
            String address = context.getEnvironment().resolvePlaceholders("${server.address:0.0.0.0}");
            if (port >= 0) {
                HttpHandler handler = (HttpHandler)context.getBeansOfType(HttpHandler.class).values().iterator().next();
                ReactorHttpHandlerAdapter adapter = new ReactorHttpHandlerAdapter(handler);
                HttpServer httpServer = HttpServer.create().host(address).port(port.intValue()).handle((BiFunction)adapter);
                Thread thread = new Thread(() -> httpServer.bindUntilJavaShutdown(Duration.ofSeconds(60L), server -> this.callback((DisposableServer)server, context)), "server-startup");
                thread.setDaemon(false);
                thread.start();
            }
        }

        private void callback(DisposableServer server, ApplicationContext context) {
            logger.info((Object)("HTTP server started on port: " + server.port()));
            if (context instanceof ConfigurableApplicationContext) {
                ((ConfigurableApplicationContext)context).getEnvironment().getPropertySources().addFirst((PropertySource)new MapPropertySource("functionalServerProps", Collections.singletonMap("local.server.port", server.port())));
            }
            try {
                double uptime = ManagementFactory.getRuntimeMXBean().getUptime();
                logger.info((Object)("JVM running for " + uptime + "ms"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
            return eventType.isAssignableFrom(ContextRefreshedEvent.class);
        }
    }

    private static class RouterFunctionRegister {
        private RouterFunctionRegister() {
        }

        private static void register(GenericApplicationContext context) {
            context.registerBean(RouterFunction.class, () -> ((FunctionEndpointFactory)context.getBean(FunctionEndpointFactory.class)).functionEndpoints(), new BeanDefinitionCustomizer[0]);
        }
    }
}

