/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.source;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.cloud.function.web.export")
public class ExporterProperties {
    private boolean autoStartup = true;
    private boolean debug = true;
    private Source source = new Source();
    private Sink sink = new Sink();
    private boolean enabled;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Source getSource() {
        return this.source;
    }

    public Sink getSink() {
        return this.sink;
    }

    public static class Source {
        private String url;
        private Class<?> type;
        private boolean includeHeaders = true;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Class<?> getType() {
            return this.type == null ? String.class : this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public void setIncludeHeaders(boolean includeHeaders) {
            this.includeHeaders = includeHeaders;
        }

        public boolean isIncludeHeaders() {
            return this.includeHeaders;
        }
    }

    public static class Sink {
        private String url;
        private Map<String, String> headers = new LinkedHashMap<String, String>();
        private String name;
        private String contentType = "application/json";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }
}

