/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.source;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.function.web.FunctionHttpProperties;
import org.springframework.cloud.function.web.source.RequestBuilder;
import org.springframework.cloud.function.web.util.HeaderUtils;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

class SimpleRequestBuilder
implements RequestBuilder {
    private String baseUrl = "http://${destination}";
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private final Environment environment;
    private final FunctionHttpProperties httpProperties;

    SimpleRequestBuilder(Environment environment, FunctionHttpProperties httpProperties) {
        this.environment = environment;
        this.httpProperties = httpProperties;
    }

    @Override
    public HttpHeaders headers(String destination, Object value) {
        MessageHeaders incoming = new MessageHeaders(Collections.emptyMap());
        if (value instanceof Message) {
            Message message = (Message)value;
            incoming = message.getHeaders();
        }
        HttpHeaders result = HeaderUtils.fromMessage(incoming, this.httpProperties.getIgnoredHeaders());
        for (String key : this.headers.keySet()) {
            String header = this.headers.get(key);
            header = header.replace("${destination}", destination);
            header = this.environment.resolvePlaceholders(header);
            result.set(key, header);
        }
        return result;
    }

    @Override
    public URI uri(String destination) {
        try {
            return new URI(this.baseUrl.replace("${destination}", destination).replace("{{destination}}", destination));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot create URI", e);
        }
    }

    public void setTemplateUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }
}

