/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.mvc;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.web.BasicStringConverter;
import org.springframework.cloud.function.web.StringConverter;
import org.springframework.cloud.function.web.mvc.FunctionController;
import org.springframework.cloud.function.web.mvc.FunctionHandlerMapping;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Flux.class, AsyncHandlerMethodReturnValueHandler.class})
@Import(value={FunctionController.class})
public class ReactorAutoConfiguration {
    @Bean
    public FunctionHandlerMapping functionHandlerMapping(FunctionProperties functionProperties, FunctionCatalog catalog, FunctionController controller) {
        return new FunctionHandlerMapping(functionProperties, catalog, controller);
    }

    @Bean
    @ConditionalOnMissingBean
    public StringConverter functionStringConverter(ConfigurableListableBeanFactory beanFactory) {
        return new BasicStringConverter(beanFactory);
    }
}

