/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.source;

import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.web.reactive.context.ConfigurableReactiveWebEnvironment;
import org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.config.ContextFunctionCatalogInitializer;
import org.springframework.cloud.function.web.source.DestinationResolver;
import org.springframework.cloud.function.web.source.ExporterProperties;
import org.springframework.cloud.function.web.source.FunctionExporterAutoConfiguration;
import org.springframework.cloud.function.web.source.RequestBuilder;
import org.springframework.cloud.function.web.source.SupplierExporter;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ConfigurableWebEnvironment;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.reactive.function.client.WebClient;

class FunctionExporterInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    FunctionExporterInitializer() {
    }

    public void initialize(GenericApplicationContext context) {
        if (ContextFunctionCatalogInitializer.enabled && ((Boolean)context.getEnvironment().getProperty("spring.functional.enabled", Boolean.class, (Object)false)).booleanValue() && this.isExporting(context)) {
            this.registerWebClient(context);
            this.registerExport(context);
        }
    }

    private void registerWebClient(GenericApplicationContext context) {
        if (ClassUtils.isPresent((String)"org.springframework.web.reactive.function.client.WebClient", (ClassLoader)this.getClass().getClassLoader()) && context.getBeanFactory().getBeanNamesForType(WebClient.Builder.class, false, false).length == 0) {
            context.registerBean(WebClient.Builder.class, () -> WebClient.builder(), new BeanDefinitionCustomizer[0]);
        }
    }

    private boolean isExporting(GenericApplicationContext context) {
        Boolean enabled = (Boolean)context.getEnvironment().getProperty("spring.cloud.function.web.export.enabled", Boolean.class);
        if (enabled != null) {
            return enabled;
        }
        return !ClassUtils.isPresent((String)"org.springframework.web.context.WebApplicationContext", (ClassLoader)this.getClass().getClassLoader()) || !(context instanceof WebApplicationContext) && !(context instanceof ReactiveWebApplicationContext) && !(context.getEnvironment() instanceof ConfigurableWebEnvironment) && !(context.getEnvironment() instanceof ConfigurableReactiveWebEnvironment);
    }

    private void registerExport(GenericApplicationContext context) {
        context.registerBean(ExporterProperties.class, () -> new ExporterProperties(), new BeanDefinitionCustomizer[0]);
        context.registerBean(FunctionExporterAutoConfiguration.class, () -> new FunctionExporterAutoConfiguration((ExporterProperties)context.getBean(ExporterProperties.class)), new BeanDefinitionCustomizer[0]);
        if (context.getBeanFactory().getBeanNamesForType(DestinationResolver.class, false, false).length == 0) {
            context.registerBean(DestinationResolver.class, () -> ((FunctionExporterAutoConfiguration)context.getBean(FunctionExporterAutoConfiguration.class)).simpleDestinationResolver(), new BeanDefinitionCustomizer[0]);
        }
        if (context.getBeanFactory().getBeanNamesForType(RequestBuilder.class, false, false).length == 0) {
            context.registerBean(RequestBuilder.class, () -> ((FunctionExporterAutoConfiguration)context.getBean(FunctionExporterAutoConfiguration.class)).simpleRequestBuilder((Environment)context.getEnvironment()), new BeanDefinitionCustomizer[0]);
        }
        if (context.getEnvironment().getProperty("spring.cloud.function.web.export.source.url") != null) {
            context.registerBean("origin", FunctionRegistration.class, () -> ((FunctionExporterAutoConfiguration)context.getBean(FunctionExporterAutoConfiguration.class)).origin((WebClient.Builder)context.getBean(WebClient.Builder.class)), new BeanDefinitionCustomizer[0]);
        }
        if (context.getEnvironment().getProperty("spring.cloud.function.web.export.sink.url") != null) {
            context.registerBean(SupplierExporter.class, () -> ((FunctionExporterAutoConfiguration)context.getBean(FunctionExporterAutoConfiguration.class)).sourceForwarder((RequestBuilder)context.getBean(RequestBuilder.class), (DestinationResolver)context.getBean(DestinationResolver.class), (FunctionCatalog)context.getBean(FunctionCatalog.class), (WebClient.Builder)context.getBean(WebClient.Builder.class)), new BeanDefinitionCustomizer[0]);
        }
    }
}

