/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ServerlessHttpSession
implements HttpSession {
    private final long creationTime;
    private final String sessionId;
    private final ServletContext servletContext;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public ServerlessHttpSession(ServletContext servletContext) {
        this.creationTime = new Date().getTime();
        this.sessionId = UUID.randomUUID().toString();
        this.servletContext = servletContext;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
    }

    public int getMaxInactiveInterval() {
        return 0;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return false;
    }
}

