/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.rsocket;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.rsocket.RSocketForwardingFunction;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class FunctionRSocketUtils {
    private static final Log LOGGER = LogFactory.getLog(FunctionRSocketUtils.class);
    public static String PAYLOAD = "payload";
    public static String HEADERS = "headers";
    private static final Pattern WS_URI_PATTERN = Pattern.compile("^(https?|wss?)://.+");

    private FunctionRSocketUtils() {
    }

    static SimpleFunctionRegistry.FunctionInvocationWrapper registerFunctionForDestination(String functionDefinition, FunctionCatalog functionCatalog, ApplicationContext applicationContext) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function;
        FunctionRSocketUtils.registerRSocketForwardingFunctionIfNecessary(functionDefinition, functionCatalog, applicationContext);
        FunctionProperties functionProperties = (FunctionProperties)applicationContext.getBean(FunctionProperties.class);
        String acceptContentType = functionProperties.getExpectedContentType();
        if (!StringUtils.hasText((String)acceptContentType)) {
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(functionDefinition);
            Type outputType = function.getOutputType();
            acceptContentType = outputType instanceof Class && String.class.isAssignableFrom((Class)outputType) ? "text/plain" : "application/json";
        }
        function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(functionDefinition, new String[]{acceptContentType});
        function.setSkipOutputConversion(true);
        return function;
    }

    static void registerRSocketForwardingFunctionIfNecessary(String definition, FunctionCatalog functionCatalog, ApplicationContext applicationContext) {
        String[] names;
        for (String name : names = StringUtils.delimitedListToStringArray((String)definition.replaceAll(",", "|").trim(), (String)"|")) {
            if (functionCatalog.lookup(name) != null) continue;
            String[] functionToRSocketDefinition = StringUtils.delimitedListToStringArray((String)name, (String)">");
            if (functionToRSocketDefinition.length == 1) {
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Registering RSocket forwarder for '" + name + "' function."));
            }
            Assert.isTrue((functionToRSocketDefinition.length == 2 ? 1 : 0) != 0, (String)("Must only contain one output redirect. Was '" + name + "'."));
            SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(functionToRSocketDefinition[0], new String[]{"application/json"});
            String[] hostPort = StringUtils.delimitedListToStringArray((String)functionToRSocketDefinition[1], (String)":");
            String forwardingUrl = functionToRSocketDefinition[1];
            RSocketRequester.Builder rsocketRequesterBuilder = (RSocketRequester.Builder)applicationContext.getBean(RSocketRequester.Builder.class);
            RSocketRequester rsocketRequester = WS_URI_PATTERN.matcher(forwardingUrl).matches() ? rsocketRequesterBuilder.websocket(URI.create(forwardingUrl)) : rsocketRequesterBuilder.tcp(hostPort[0], Integer.parseInt(hostPort[1]));
            RSocketForwardingFunction rsocketFunction = new RSocketForwardingFunction(function, rsocketRequester, null);
            FunctionRegistration functionRegistration = new FunctionRegistration((Object)rsocketFunction, new String[]{name});
            functionRegistration.type(FunctionTypeUtils.discoverFunctionTypeFromClass(RSocketForwardingFunction.class));
            ((FunctionRegistry)functionCatalog).register(functionRegistration);
        }
    }

    static Map<String, Object> sanitizeMessageToMap(Message<?> message) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put(PAYLOAD, message.getPayload());
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (String key : message.getHeaders().keySet()) {
            if (key.equals("lookupDestination") || key.equals("reconciledLookupDestination") || key.equals("contentType")) {
                headers.put(key, message.getHeaders().get((Object)key).toString());
                continue;
            }
            if (key.equals("rsocketRequester")) continue;
            headers.put(key, message.getHeaders().get((Object)key));
        }
        messageMap.put(HEADERS, headers);
        return messageMap;
    }
}

