/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.config.CoroutinesUtils;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;

@Configuration
@ConditionalOnClass(name={"kotlin.jvm.functions.Function0"})
public class KotlinLambdaToFunctionAutoConfiguration {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Bean
    public BeanFactoryPostProcessor kotlinToFunctionTransformerOld() {
        return new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                String[] beanDefinitionNames;
                for (String beanDefinitionName : beanDefinitionNames = beanFactory.getBeanDefinitionNames()) {
                    String typeName;
                    BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDefinitionName);
                    if (!(beanDefinition instanceof AnnotatedBeanDefinition) || ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata() == null || !(typeName = ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata().getReturnTypeName()).startsWith("kotlin.jvm.functions.Function")) continue;
                    RootBeanDefinition cbd = new RootBeanDefinition(KotlinFunctionWrapper.class);
                    ConstructorArgumentValues ca = new ConstructorArgumentValues();
                    ca.addGenericArgumentValue((Object)beanDefinition);
                    cbd.setConstructorArgumentValues(ca);
                    ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(beanDefinitionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX, (BeanDefinition)cbd);
                }
            }
        };
    }

    private static final class KotlinFunctionWrapper
    implements Function<Object, Object>,
    Supplier<Object>,
    Consumer<Object[]>,
    Function0<Object>,
    Function1<Object, Object>,
    Function2<Object, Object, Object>,
    Function3<Object, Object, Object, Object>,
    Function4<Object, Object, Object, Object, Object>,
    FactoryBean<FunctionRegistration>,
    BeanNameAware,
    BeanFactoryAware {
        private final Object kotlinLambdaTarget;
        private String name;
        private ConfigurableListableBeanFactory beanFactory;

        private KotlinFunctionWrapper(Object kotlinLambdaTarget) {
            this.kotlinLambdaTarget = kotlinLambdaTarget;
        }

        @Override
        public Object apply(Object input) {
            if (ObjectUtils.isEmpty((Object)input)) {
                return this.invoke();
            }
            if (ObjectUtils.isArray((Object)input)) {
                return null;
            }
            return this.invoke(input);
        }

        public Object invoke(Object arg0, Object arg1, Object arg2, Object arg3) {
            return ((Function4)this.kotlinLambdaTarget).invoke(arg0, arg1, arg2, arg3);
        }

        public Object invoke(Object arg0, Object arg1, Object arg2) {
            return ((Function3)this.kotlinLambdaTarget).invoke(arg0, arg1, arg2);
        }

        public Object invoke(Object arg0, Object arg1) {
            return ((Function2)this.kotlinLambdaTarget).invoke(arg0, arg1);
        }

        public Object invoke(Object arg0) {
            if (CoroutinesUtils.isValidSuspendingFunction(this.kotlinLambdaTarget, arg0)) {
                return CoroutinesUtils.invokeSuspendingFunction(this.kotlinLambdaTarget, arg0);
            }
            return ((Function1)this.kotlinLambdaTarget).invoke(arg0);
        }

        public Object invoke() {
            if (CoroutinesUtils.isValidSuspendingSupplier(this.kotlinLambdaTarget)) {
                return CoroutinesUtils.invokeSuspendingSupplier(this.kotlinLambdaTarget);
            }
            return ((Function0)this.kotlinLambdaTarget).invoke();
        }

        @Override
        public void accept(Object[] input) {
            this.apply(input);
        }

        @Override
        public Object get() {
            return this.apply((Object)null);
        }

        public FunctionRegistration getObject() throws Exception {
            String name = this.name.endsWith(FunctionRegistration.REGISTRATION_NAME_SUFFIX) ? this.name.replace(FunctionRegistration.REGISTRATION_NAME_SUFFIX, "") : this.name;
            Type functionType = FunctionContextUtils.findType((String)name, (ConfigurableListableBeanFactory)this.beanFactory);
            FunctionRegistration registration = new FunctionRegistration((Object)this, new String[]{name});
            Type[] types = ((ParameterizedType)functionType).getActualTypeArguments();
            if (functionType.getTypeName().contains("Function0")) {
                functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)types[0])}).getType();
            } else if (this.isValidKotlinFunction(functionType, types)) {
                functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)types[0]), ResolvableType.forType((Type)types[1])}).getType();
            } else if (this.isValidKotlinSuspendSupplier(functionType, types)) {
                Type continuationReturnType = CoroutinesUtils.getSuspendingFunctionReturnType(types[0]);
                functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)continuationReturnType)})}).getType();
            } else if (this.isValidKotlinSuspendFunction(functionType, types)) {
                Type continuationArgType = CoroutinesUtils.getSuspendingFunctionArgType(types[0]);
                Type continuationReturnType = CoroutinesUtils.getSuspendingFunctionReturnType(types[1]);
                functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)continuationArgType)}), ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)continuationReturnType)})}).getType();
            } else if (this.isValidKotlinSuspendConsumer(functionType, types)) {
                Type continuationArgType = CoroutinesUtils.getSuspendingFunctionArgType(types[0]);
                functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)continuationArgType)})}).getType();
            } else {
                throw new UnsupportedOperationException("Multi argument Kotlin functions are not currently supported");
            }
            registration = registration.type(functionType);
            return registration;
        }

        private boolean isValidKotlinFunction(Type functionType, Type[] type) {
            return functionType.getTypeName().contains(Function1.class.getName()) && type.length == 2 && !CoroutinesUtils.isContinuationType(type[0]);
        }

        private boolean isValidKotlinSuspendSupplier(Type functionType, Type[] type) {
            return functionType.getTypeName().contains(Function1.class.getName()) && type.length == 2 && CoroutinesUtils.isContinuationFlowType(type[0]);
        }

        private boolean isValidKotlinSuspendConsumer(Type functionType, Type[] type) {
            return functionType.getTypeName().contains(Function2.class.getName()) && type.length == 3 && CoroutinesUtils.isFlowType(type[0]) && CoroutinesUtils.isContinuationUnitType(type[1]);
        }

        private boolean isValidKotlinSuspendFunction(Type functionType, Type[] type) {
            return functionType.getTypeName().contains(Function2.class.getName()) && type.length == 3 && CoroutinesUtils.isContinuationFlowType(type[1]);
        }

        public Class<?> getObjectType() {
            return FunctionRegistration.class;
        }

        public void setBeanName(String name) {
            this.name = name;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }
    }
}

