/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.function.deployer.ApplicationRunner;
import org.springframework.util.StringUtils;

public class ApplicationBootstrap {
    private static Log logger = LogFactory.getLog(ApplicationBootstrap.class);
    private ApplicationRunner runner;
    private URLClassLoader classLoader;

    private static boolean isolated(String[] args) {
        for (String arg : args) {
            if (!arg.equals("--function.runner.isolated=false")) continue;
            return false;
        }
        return true;
    }

    public void run(Class<?> mainClass, String ... args) {
        if (ApplicationBootstrap.isolated(args)) {
            this.runner(mainClass).run(args);
        } else {
            SpringApplication.run(mainClass, (String[])args);
        }
    }

    public void close() {
        if (this.runner != null) {
            this.runner.close();
            this.runner = null;
        }
        if (this.classLoader != null) {
            try {
                this.classLoader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot close ClassLoader", e);
            }
            finally {
                this.classLoader = null;
            }
        }
    }

    public ApplicationRunner getRunner() {
        return this.runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationRunner runner(Class<?> mainClass) {
        if (this.runner == null) {
            ApplicationBootstrap applicationBootstrap = this;
            synchronized (applicationBootstrap) {
                if (this.runner == null) {
                    this.classLoader = this.createClassLoader(mainClass);
                    this.runner = new ApplicationRunner(this.classLoader, mainClass.getName());
                    Runtime.getRuntime().addShutdownHook(new Thread(this::close));
                }
            }
        }
        return this.runner;
    }

    private URLClassLoader createClassLoader(Class<?> mainClass) {
        URL[] classpath;
        URL[] urls = this.findClassPath(mainClass);
        if (urls.length == 1 && (classpath = this.extractClasspath(urls[0])) != null) {
            urls = classpath;
        }
        ArrayList<URL> child = new ArrayList<URL>();
        ArrayList<URL> parent = new ArrayList<URL>();
        for (URL url : urls) {
            child.add(url);
        }
        for (URL url : urls) {
            if (!this.isRoot(StringUtils.getFilename((String)this.clean(url.toString())))) continue;
            parent.add(url);
            child.remove(url);
        }
        logger.debug((Object)("Parent: " + parent));
        logger.debug((Object)("Child: " + child));
        ClassLoader base = this.getClass().getClassLoader();
        if (!parent.isEmpty()) {
            base = new URLClassLoader(parent.toArray(new URL[0]), base.getParent());
        }
        return new URLClassLoader(child.toArray(new URL[0]), base);
    }

    private URL[] findClassPath(Class<?> mainClass) {
        ClassLoader base = mainClass.getClassLoader();
        if (!(base instanceof URLClassLoader)) {
            try {
                ArrayList<URL> list = Collections.list(mainClass.getClassLoader().getResources("META-INF"));
                ArrayList<URL> result = new ArrayList<URL>();
                result.add(mainClass.getProtectionDomain().getCodeSource().getLocation());
                for (URL url : list) {
                    String path = url.toString();
                    path = path.substring(0, path.length() - "/META-INF".length()) + "/";
                    result.add(new URL(path));
                }
                return result.toArray(new URL[result.size()]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot find class path", e);
            }
        }
        URLClassLoader urlClassLoader = (URLClassLoader)base;
        return urlClassLoader.getURLs();
    }

    private boolean isRoot(String file) {
        return file.startsWith("reactor-core") || file.startsWith("reactive-streams");
    }

    private String clean(String jar) {
        return jar.endsWith("!/") ? jar.substring(0, jar.length() - 2) : jar;
    }

    private URL[] extractClasspath(URL url) {
        if (url.toString().endsWith(".jar")) {
            try {
                JarFile jar = new JarFile(new File(url.toURI()));
                String path = jar.getManifest().getMainAttributes().getValue("Class-Path");
                if (path != null) {
                    ArrayList<URL> result = new ArrayList<URL>();
                    for (String element : path.split(" ")) {
                        result.add(new URL(element));
                    }
                    return result.toArray(new URL[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

