/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.loader.JarLauncher;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.system.JavaVersion;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.core.FluxFunction;
import org.springframework.cloud.function.deployer.ApplicationRunner;
import org.springframework.cloud.function.deployer.ContextRunner;
import org.springframework.cloud.function.deployer.FunctionProperties;
import org.springframework.cloud.function.deployer.SingleEntryFunctionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

@Configuration
class FunctionCreatorConfiguration {
    private static Log logger = LogFactory.getLog(FunctionCreatorConfiguration.class);
    @Autowired
    private FunctionRegistry registry;
    @Autowired
    private FunctionProperties properties;
    @Autowired
    private DelegatingResourceLoader delegatingResourceLoader;
    @Autowired
    private ConfigurableApplicationContext context;
    private BeanCreatorClassLoader functionClassLoader;
    private BeanCreator creator;

    FunctionCreatorConfiguration() {
    }

    @PostConstruct
    public void init() {
        URL[] urls = (URL[])Arrays.stream(this.properties.getLocation()).flatMap(this.toResourceURL(this.delegatingResourceLoader)).toArray(URL[]::new);
        URL[] roots = (URL[])Arrays.stream(this.properties.getLocation()).map(this::toUrl).toArray(URL[]::new);
        try {
            logger.info((Object)("Locating function from " + Arrays.asList(this.properties.getLocation())));
            this.creator = new BeanCreator(roots, urls);
            this.creator.run(this.properties.getMain());
            ((Stream)Arrays.stream(this.functionNames()).map(this.creator::create).sequential()).forEach(this.creator::register);
            if (this.properties.getName().contains("|")) {
                this.registry.lookup(Consumer.class, this.properties.getName());
                this.registry.lookup(Function.class, this.properties.getName());
                this.registry.lookup(Supplier.class, this.properties.getName());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create functions", e);
        }
    }

    private URL toUrl(String url) {
        if (url.equals("app:classpath")) {
            return this.urls()[0];
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String[] functionNames() {
        if (this.properties.getBean() != null && this.properties.getBean().length > 0) {
            return this.properties.getBean();
        }
        return this.creator.getFunctionNames();
    }

    @PreDestroy
    public void close() {
        if (this.creator != null) {
            this.creator.close();
        }
        if (this.functionClassLoader != null) {
            try {
                this.functionClassLoader.close();
                this.functionClassLoader = null;
                Runtime.getRuntime().gc();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot close function class loader", e);
            }
        }
    }

    private Function<String, Stream<URL>> toResourceURL(DelegatingResourceLoader resourceLoader) {
        return l -> {
            if (l.equals("app:classpath")) {
                return Stream.of(this.urls());
            }
            try {
                return Stream.of(resourceLoader.getResource(l).getFile().toURI().toURL());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private URL[] urls() {
        if (this.getClass().getClassLoader() instanceof URLClassLoader) {
            return ((URLClassLoader)this.getClass().getClassLoader()).getURLs();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        String jcp = System.getProperty("java.class.path");
        StringTokenizer jcpEntries = new StringTokenizer(jcp, File.pathSeparator);
        while (jcpEntries.hasMoreTokens()) {
            String pathEntry = jcpEntries.nextToken();
            try {
                urls.add(new File(pathEntry).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return urls.toArray(new URL[urls.size()]);
    }

    @Configuration
    protected static class SingleEntryConfiguration
    implements BeanPostProcessor {
        @Autowired
        private Environment env;

        protected SingleEntryConfiguration() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            String name;
            if (bean instanceof FunctionRegistry && (name = FunctionProperties.functionName(this.env.getProperty("function.bean", ""))).contains("|")) {
                bean = new SingleEntryFunctionRegistry((FunctionRegistry)bean, name);
            }
            return bean;
        }
    }

    private static final class BeanCreatorClassLoader
    extends URLClassLoader {
        private BeanCreatorClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                if (name.startsWith("javax.") && JavaVersion.getJavaVersion().isEqualOrNewerThan(JavaVersion.NINE)) {
                    return this.getClass().getClassLoader().loadClass(name);
                }
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                if (name.contains(ContextRunner.class.getName()) || name.contains(PostConstruct.class.getName())) {
                    try {
                        byte[] bytes = StreamUtils.copyToByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream(ClassUtils.convertClassNameToResourcePath((String)name) + ".class"));
                        return this.defineClass(name, bytes, 0, bytes.length);
                    }
                    catch (IOException ex) {
                        throw new ClassNotFoundException("Cannot find runner class: " + name, ex);
                    }
                }
                throw e;
            }
        }
    }

    private class BeanCreator {
        private AtomicInteger counter = new AtomicInteger(0);
        private ApplicationRunner runner;
        private String defaultMain;

        public BeanCreator(URL[] roots, URL[] urls) {
            FunctionCreatorConfiguration.this.functionClassLoader = new BeanCreatorClassLoader(this.expand(urls), this.getParent());
            this.defaultMain = this.findMain(roots);
        }

        private ClassLoader getParent() {
            ClassLoader loader = this.getClass().getClassLoader();
            ClassLoader parent = loader = loader.getParent();
            while (loader.getParent() != null) {
                if (loader.getResource("META-INF/spring.factories") != null) {
                    parent = loader.getParent();
                }
                loader = loader.getParent();
            }
            return parent;
        }

        private String findMain(URL[] urls) {
            for (URL url : urls) {
                try {
                    JarFileArchive archive;
                    String main;
                    File file = ResourceUtils.getFile((URL)url);
                    if (!file.exists() || (main = new ComputeLauncher((Archive)(archive = file.getName().endsWith(".jar") ? new JarFileArchive(file) : new ExplodedArchive(file))).getMainClass()) == null) continue;
                    return main;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private URL[] expand(URL[] urls) {
            ArrayList<URL> result = new ArrayList<URL>();
            for (URL url : urls) {
                result.addAll(this.expand(url));
            }
            return result.toArray(new URL[0]);
        }

        private List<URL> expand(URL url) {
            if (!"file".equals(url.getProtocol())) {
                return Collections.singletonList(url);
            }
            try {
                File file = new File(url.toURI());
                if (file.exists()) {
                    JarFileArchive archive;
                    if (!url.toString().endsWith(".jar")) {
                        if (!new File(file, "BOOT-INF").exists()) {
                            return Collections.singletonList(url);
                        }
                        archive = new ExplodedArchive(file);
                    } else {
                        archive = new JarFileArchive(file);
                    }
                    return Arrays.asList(new ComputeLauncher((Archive)archive).getClassLoaderUrls());
                }
                return Collections.singletonList(url);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create class loader for " + url, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String main) {
            if (main == null) {
                main = this.defaultMain;
            }
            if (main == null) {
                return;
            }
            if (ClassUtils.isPresent((String)SpringApplication.class.getName(), (ClassLoader)FunctionCreatorConfiguration.this.functionClassLoader)) {
                logger.info((Object)("SpringApplication available. Bootstrapping: " + main));
                ClassLoader contextClassLoader = ClassUtils.overrideThreadContextClassLoader((ClassLoader)FunctionCreatorConfiguration.this.functionClassLoader);
                try {
                    ApplicationRunner runner = new ApplicationRunner(FunctionCreatorConfiguration.this.functionClassLoader, main);
                    runner.run("--spring.main.webEnvironment=false", "--spring.cloud.stream.enabled=false", "--spring.main.bannerMode=OFF", "--spring.main.webApplicationType=none", "--function.deployer.enabled=false");
                    this.runner = runner;
                }
                finally {
                    ClassUtils.overrideThreadContextClassLoader((ClassLoader)contextClassLoader);
                }
            } else {
                throw new IllegalStateException("SpringApplication not available and main class requested: " + main);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getFunctionNames() {
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            ClassLoader contextClassLoader = ClassUtils.overrideThreadContextClassLoader((ClassLoader)FunctionCreatorConfiguration.this.functionClassLoader);
            try {
                if (this.runner.containsBean(FunctionCatalog.class.getName())) {
                    Object catalog = this.runner.getBean(FunctionCatalog.class.getName());
                    Set functions = (Set)this.runner.evaluate("getNames(#type)", catalog, "type", Function.class);
                    list.addAll(functions);
                    Set consumers = (Set)this.runner.evaluate("getNames(#type)", catalog, "type", Consumer.class);
                    list.addAll(consumers);
                    Set suppliers = (Set)this.runner.evaluate("getNames(#type)", catalog, "type", Supplier.class);
                    list.addAll(suppliers);
                }
                if (list.isEmpty()) {
                    list.addAll(this.runner.getBeanNames(Function.class.getName()));
                    list.addAll(this.runner.getBeanNames(Consumer.class.getName()));
                    list.addAll(this.runner.getBeanNames(Supplier.class.getName()));
                }
                String[] stringArray = list.toArray(new String[0]);
                return stringArray;
            }
            finally {
                ClassUtils.overrideThreadContextClassLoader((ClassLoader)contextClassLoader);
            }
        }

        public Object create(String type) {
            ClassLoader contextClassLoader = ClassUtils.overrideThreadContextClassLoader((ClassLoader)FunctionCreatorConfiguration.this.functionClassLoader);
            AutowireCapableBeanFactory factory = FunctionCreatorConfiguration.this.context.getAutowireCapableBeanFactory();
            try {
                Object result = null;
                if (this.runner != null) {
                    result = this.runner.getBean(type);
                    if (result == null) {
                        Object catalog;
                        if (this.runner.containsBean(FunctionCatalog.class.getName()) && (result = this.runner.evaluate("lookup(#function).getTarget()", catalog = this.runner.getBean(FunctionCatalog.class.getName()), "function", type)) != null) {
                            logger.info((Object)("Located registration: " + type + " of type " + result.getClass()));
                        }
                    } else {
                        logger.info((Object)("Located bean: " + type + " of type " + result.getClass()));
                        if (result.getClass().getName().equals(FunctionRegistration.class.getName())) {
                            result = this.runner.evaluate("getTarget()", result, new Object[0]);
                        }
                    }
                    if (result != null && result.getClass().getName().equals(FluxFunction.class.getName())) {
                        result = this.runner.evaluate("getTarget()", result, new Object[0]);
                    }
                }
                if (result == null) {
                    logger.info((Object)("No bean found. Instantiating: " + type));
                    if (ClassUtils.isPresent((String)type, (ClassLoader)FunctionCreatorConfiguration.this.functionClassLoader)) {
                        result = factory.createBean(ClassUtils.resolveClassName((String)type, (ClassLoader)FunctionCreatorConfiguration.this.functionClassLoader));
                    }
                }
                if (result != null) {
                    Object object = result;
                    return object;
                }
                throw new IllegalStateException("Cannot create bean for: " + type);
            }
            finally {
                ClassUtils.overrideThreadContextClassLoader((ClassLoader)contextClassLoader);
            }
        }

        public void register(Object bean) {
            if (bean == null) {
                return;
            }
            FunctionRegistration registration = new FunctionRegistration(bean, new String[]{FunctionProperties.functionName(this.counter.getAndIncrement())});
            if (this.runner != null) {
                if (this.runner.containsBean(FunctionInspector.class.getName())) {
                    Class<?> outputWrapper;
                    Class<?> inputWrapper;
                    Object inspector = this.runner.getBean(FunctionInspector.class.getName());
                    Class input = (Class)this.runner.evaluate("getInputType(#function)", inspector, "function", bean);
                    FunctionType type = FunctionType.from((Class)input);
                    Class<?> output = this.findType("getOutputType", inspector, bean);
                    type = type.to(output);
                    if (((Boolean)this.runner.evaluate("isMessage(#function)", inspector, "function", bean)).booleanValue()) {
                        type = type.message();
                    }
                    if (FunctionType.isWrapper(inputWrapper = this.findType("getInputWrapper", inspector, bean))) {
                        type = type.wrap(inputWrapper);
                    }
                    if (FunctionType.isWrapper(outputWrapper = this.findType("getOutputWrapper", inspector, bean))) {
                        type = type.wrap(outputWrapper);
                    }
                    registration.type(type.getType());
                }
            } else {
                registration.type(FunctionType.of(bean.getClass()).getType());
            }
            registration.target(bean);
            FunctionCreatorConfiguration.this.registry.register(registration);
        }

        private Class<?> findType(String method, Object inspector, Object bean) {
            return (Class)this.runner.evaluate(method + "(#function)", inspector, "function", bean);
        }

        public void close() {
            if (this.runner != null) {
                this.runner.close();
            }
        }
    }

    private class ComputeLauncher
    extends JarLauncher {
        public ComputeLauncher(Archive archive) {
            super(archive);
        }

        public String getMainClass() throws Exception {
            Manifest manifest = this.getArchive().getManifest();
            String mainClass = null;
            if (manifest != null) {
                String functionClass = manifest.getMainAttributes().getValue("Function-Class");
                if (StringUtils.hasText((String)functionClass) && ObjectUtils.isEmpty((Object[])FunctionCreatorConfiguration.this.properties.getBean())) {
                    FunctionCreatorConfiguration.this.properties.setBean(new String[]{functionClass});
                }
                if ((mainClass = manifest.getMainAttributes().getValue("Start-Class")) == null && !this.getArchive().getUrl().toString().endsWith(".jar!/")) {
                    mainClass = manifest.getMainAttributes().getValue("Main-Class");
                }
            }
            return mainClass;
        }

        public URL[] getClassLoaderUrls() throws Exception {
            List archives = this.getClassPathArchives();
            if (archives.isEmpty()) {
                URL[] classpath;
                URL url = this.getArchive().getUrl();
                if (url.toString().contains(".jar") && (classpath = this.extractClasspath(url.toString())) != null) {
                    return classpath;
                }
                return new URL[]{this.getArchive().getUrl()};
            }
            return (URL[])archives.stream().map(archive -> {
                try {
                    return archive.getUrl();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Bad URL: " + archive, e);
                }
            }).toArray(URL[]::new);
        }

        private URL[] extractClasspath(String url) {
            if (url.endsWith(".jar!/")) {
                if ((url = url.substring(0, url.length() - "!/".length())).startsWith("jar:")) {
                    url = url.substring("jar:".length());
                }
                if (url.startsWith("file:")) {
                    url = url.substring("file:".length());
                }
            }
            if (url.endsWith(".jar")) {
                try {
                    JarFile jar = new JarFile(new File(url));
                    String path = jar.getManifest().getMainAttributes().getValue("Class-Path");
                    if (path != null) {
                        ArrayList<URL> result = new ArrayList<URL>();
                        for (String element : path.split(" ")) {
                            result.add(new URL(element));
                        }
                        return result.toArray(new URL[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

