/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.json;

import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.json.JsonMapper;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.type.TypeFactory;

public class JacksonMapper
extends JsonMapper {
    private static Log logger = LogFactory.getLog(JacksonMapper.class);
    private final ObjectMapper mapper;

    public JacksonMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void configureObjectMapper(Consumer<ObjectMapper> configurer) {
        configurer.accept(this.mapper);
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    @Override
    protected <T> T doFromJson(Object json, Type type) {
        Object convertedValue = null;
        JavaType constructType = TypeFactory.createDefaultInstance().constructType(type);
        try {
            if (json instanceof String) {
                convertedValue = this.mapper.readValue((String)json, constructType);
            } else if (json instanceof byte[]) {
                convertedValue = this.mapper.readValue((byte[])json, constructType);
            } else if (json instanceof Reader) {
                convertedValue = this.mapper.readValue((Reader)json, constructType);
            } else if (json instanceof Map) {
                convertedValue = this.mapper.convertValue(json, constructType);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert. Possible bug as the conversion probably shouldn't have been attempted here", e);
        }
        return (T)convertedValue;
    }

    @Override
    public byte[] toJson(Object value) {
        byte[] jsonBytes;
        block3: {
            jsonBytes = super.toJson(value);
            if (jsonBytes == null) {
                try {
                    jsonBytes = this.mapper.writeValueAsBytes(value);
                }
                catch (Exception e) {
                    if (!logger.isTraceEnabled()) break block3;
                    logger.trace((Object)("Failed to writeValueAsBytes: " + String.valueOf(value)), (Throwable)e);
                }
            }
        }
        return jsonBytes;
    }

    @Override
    public String toString(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert to JSON", e);
        }
    }
}

