/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.utils;

import java.util.Locale;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.messaging.MessageHeaders;

public final class FunctionMessageUtils {
    private FunctionMessageUtils() {
    }

    private static String determineSourceFromHeaders(MessageHeaders headers) {
        for (String key : headers.keySet()) {
            if (key.equals(MessageUtils.SOURCE_TYPE)) {
                return (String)headers.get((Object)MessageUtils.SOURCE_TYPE);
            }
            if (key.startsWith("amqp_")) {
                return "amqp";
            }
            if (key.startsWith("kafka_")) {
                return "kafka";
            }
            if (key.startsWith("aws_")) {
                return "aws";
            }
            if (key.startsWith("solace_")) {
                return "solace";
            }
            if (!key.toLowerCase(Locale.ROOT).equals("user-agent") && !key.toLowerCase(Locale.ROOT).equals("accept-encoding") && !key.toLowerCase(Locale.ROOT).equals("host")) continue;
            return "http";
        }
        return "origin";
    }
}

