/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.flow.Flow;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

public final class KotlinSupplierFlowWrapper
implements KotlinFunctionWrapper,
Supplier<Flux<Object>>,
Function0<Flow<Object>> {
    private final Object kotlinLambdaTarget;
    private final String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinSupplier(functionType) && types.length == 1 && KotlinUtils.isFlowType(types[0]);
    }

    public static KotlinSupplierFlowWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType props = ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)propsTypes[0])});
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{props});
        return new KotlinSupplierFlowWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinSupplierFlowWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.type = type;
        this.name = functionName;
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Flux<Object> get() {
        Flow<Object> result = this.invoke();
        return KotlinUtils.convertToFlux(result);
    }

    public Flow<Object> invoke() {
        if (this.kotlinLambdaTarget instanceof Function0) {
            Function0 target = (Function0)this.kotlinLambdaTarget;
            Flow result = (Flow)target.invoke();
            return result;
        }
        if (this.kotlinLambdaTarget instanceof Supplier) {
            Supplier target = (Supplier)this.kotlinLambdaTarget;
            Flow result = (Flow)target.get();
            return result;
        }
        throw new IllegalArgumentException("Unsupported target type: " + this.kotlinLambdaTarget.getClass());
    }
}

