/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Function;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import org.springframework.cloud.function.context.config.CoroutinesUtils;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

public final class KotlinFunctionSuspendFlowToPlainWrapper
implements KotlinFunctionWrapper,
Function<Flux<Object>, Object>,
Function1<Flux<Object>, Object> {
    private final Object kotlinLambdaTarget;
    private final String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinSuspendFunction(functionType, types) && types.length == 3 && KotlinUtils.isFlowType(types[0]) && KotlinUtils.isContinuationType(types[1]) && !KotlinUtils.isContinuationFlowType(types[1]);
    }

    public static KotlinFunctionSuspendFlowToPlainWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType argType = KotlinUtils.getSuspendingFunctionArgType(propsTypes[0]);
        ResolvableType result = KotlinUtils.getSuspendingFunctionReturnType(propsTypes[1]);
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{argType}), result});
        return new KotlinFunctionSuspendFlowToPlainWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinFunctionSuspendFlowToPlainWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.name = functionName;
        this.type = type;
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    public Object invoke(Flux<Object> arg0) {
        Flow<Object> flow = KotlinUtils.convertToFlow(arg0);
        return CoroutinesUtils.invokeSuspendingFlowFunction(this.kotlinLambdaTarget, flow);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object apply(Flux<Object> input) {
        return this.invoke(input);
    }
}

