/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

public final class KotlinConsumerFlowWrapper
implements KotlinFunctionWrapper,
Consumer<Flux<Object>>,
Function1<Flow<Object>, Unit> {
    private final Object kotlinLambdaTarget;
    private final String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinConsumer(functionType, types) && KotlinUtils.isFlowType(types[0]);
    }

    public static KotlinConsumerFlowWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType props = ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)propsTypes[0])});
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{props});
        return new KotlinConsumerFlowWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinConsumerFlowWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.type = type;
        this.name = functionName;
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void accept(Flux<Object> props) {
        Flow<Object> flow = KotlinUtils.convertToFlow(props);
        this.invoke(flow);
    }

    public Unit invoke(Flow<Object> props) {
        if (this.kotlinLambdaTarget instanceof Function1) {
            Function1 function = (Function1)this.kotlinLambdaTarget;
            return (Unit)function.invoke(props);
        }
        if (this.kotlinLambdaTarget instanceof Consumer) {
            Consumer target = (Consumer)this.kotlinLambdaTarget;
            target.accept(props);
            return Unit.INSTANCE;
        }
        throw new IllegalArgumentException("Unsupported target type: " + this.kotlinLambdaTarget.getClass());
    }
}

