/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.context.config.JsonMessageConverter;
import org.springframework.cloud.function.context.config.SmartCompositeMessageConverter;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
public abstract class AbstractSpringFunctionAdapterInitializer<C>
implements Closeable {
    private static Log logger = LogFactory.getLog(AbstractSpringFunctionAdapterInitializer.class);
    public static final String TARGET_EXECUTION_CTX_NAME = "executionContext";
    private final Class<?> configurationClass;
    private Function function;
    private Consumer consumer;
    private Supplier supplier;
    private FunctionRegistration<?> functionRegistration;
    private AtomicBoolean initialized = new AtomicBoolean();
    @Autowired(required=false)
    protected FunctionCatalog catalog;
    @Autowired(required=false)
    protected JsonMapper jsonMapper;
    private ConfigurableApplicationContext context;

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public AbstractSpringFunctionAdapterInitializer(Class<?> configurationClass) {
        Assert.notNull(configurationClass, (String)"'configurationClass' must not be null");
        this.configurationClass = configurationClass;
    }

    public AbstractSpringFunctionAdapterInitializer() {
        this(FunctionClassUtils.getStartClass());
    }

    @Override
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    protected void initialize(C targetContext) {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        logger.info((Object)("Initializing: " + this.configurationClass));
        SpringApplication builder = this.springApplication();
        ConfigurableApplicationContext context = builder.run(new String[0]);
        context.getAutowireCapableBeanFactory().autowireBean((Object)this);
        this.context = context;
        if (this.catalog == null) {
            SmartCompositeMessageConverter messageConverter = new SmartCompositeMessageConverter(Collections.singletonList(new JsonMessageConverter(new JacksonMapper(new ObjectMapper()))));
            this.catalog = new SimpleFunctionRegistry((ConversionService)new GenericConversionService(), messageConverter, new JacksonMapper(new ObjectMapper()));
            this.initFunctionConsumerOrSupplierFromContext(targetContext);
        } else {
            this.initFunctionConsumerOrSupplierFromCatalog(targetContext);
        }
    }

    protected Class<?> getInputType() {
        Object func = this.function();
        if (func != null && func instanceof SimpleFunctionRegistry.FunctionInvocationWrapper) {
            return FunctionTypeUtils.getRawType(FunctionTypeUtils.getGenericType(((SimpleFunctionRegistry.FunctionInvocationWrapper)func).getInputType()));
        }
        if (this.functionRegistration != null) {
            return this.functionRegistration.getType().getInputType();
        }
        return Object.class;
    }

    protected Function<Publisher<?>, Publisher<?>> getFunction() {
        return this.function;
    }

    protected Object function() {
        if (this.function != null) {
            return this.function;
        }
        if (this.consumer != null) {
            return this.consumer;
        }
        if (this.supplier != null) {
            return this.supplier;
        }
        return null;
    }

    protected Publisher<?> apply(Publisher<?> input) {
        if (this.function != null) {
            Object result = this.function.apply(input);
            if (result instanceof Publisher) {
                return Flux.from((Publisher)((Publisher)result));
            }
            return Flux.just(result);
        }
        if (this.consumer != null) {
            this.consumer.accept(input);
            return Flux.empty();
        }
        if (this.supplier != null) {
            Object result = this.supplier.get();
            if (!(result instanceof Publisher)) {
                result = Mono.just(result);
            }
            return (Publisher)result;
        }
        throw new IllegalStateException("No function defined");
    }

    protected String doResolveName(Object targetContext) {
        return "";
    }

    protected Object convertOutput(Object input, Object output) {
        return output;
    }

    protected <O> O result(Object input, Publisher<?> output) {
        Object value;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value2 : Flux.from(output).toIterable()) {
            result.add(this.convertOutput(input, value2));
        }
        if (this.isSingleInput(this.getFunction(), input) && result.size() == 1) {
            value = result.get(0);
            return (O)value;
        }
        if (this.isSingleOutput(this.getFunction(), input) && result.size() == 1) {
            value = result.get(0);
            return (O)value;
        }
        value = result;
        return CollectionUtils.isEmpty(result) ? null : (O)value;
    }

    protected void clear(String name) {
        SimpleFunctionRegistry.FunctionInvocationWrapper f = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.catalog.lookup(name);
        if (f.isFunction()) {
            this.function = f;
        } else if (f.isConsumer()) {
            this.consumer = f;
        } else {
            this.supplier = f;
        }
    }

    private boolean isSingleInput(Function<?, ?> function, Object input) {
        if (!(input instanceof Collection)) {
            return true;
        }
        if (function != null) {
            return Collection.class.isAssignableFrom(((SimpleFunctionRegistry.FunctionInvocationWrapper)function).getRawInputType());
        }
        return ((Collection)input).size() <= 1;
    }

    private boolean isSingleOutput(Function<?, ?> function, Object output) {
        if (!(output instanceof Collection)) {
            return true;
        }
        if (function != null) {
            Class<?> outputType = FunctionTypeUtils.getRawType(FunctionTypeUtils.getGenericType(((SimpleFunctionRegistry.FunctionInvocationWrapper)function).getOutputType()));
            return Collection.class.isAssignableFrom(outputType);
        }
        return ((Collection)output).size() <= 1;
    }

    private String resolveName(Class<?> type, Object targetContext) {
        String functionName = this.context.getEnvironment().getProperty("function.name");
        if (functionName != null) {
            return functionName;
        }
        if (type.isAssignableFrom(Function.class)) {
            return "function";
        }
        if (type.isAssignableFrom(Consumer.class)) {
            return "consumer";
        }
        if (type.isAssignableFrom(Supplier.class)) {
            return "supplier";
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    private <T> T getAndInstrumentFromContext(String name) {
        this.functionRegistration = new FunctionRegistration<Object>(this.context.getBean(name), name);
        Type type = FunctionContextUtils.findType(name, this.context.getBeanFactory());
        this.functionRegistration = this.functionRegistration.type(new FunctionType(type));
        ((FunctionRegistry)this.catalog).register(this.functionRegistration);
        return this.catalog.lookup(name);
    }

    private void initFunctionConsumerOrSupplierFromContext(Object targetContext) {
        String name = this.resolveName(Function.class, targetContext);
        if (this.context.containsBean(name) && this.context.getBean(name) instanceof Function) {
            this.function = (Function)this.getAndInstrumentFromContext(name);
            return;
        }
        name = this.resolveName(Consumer.class, targetContext);
        if (this.context.containsBean(name) && this.context.getBean(name) instanceof Consumer) {
            this.function = (Function)this.getAndInstrumentFromContext(name);
            return;
        }
        name = this.resolveName(Supplier.class, targetContext);
        if (this.context.containsBean(name) && this.context.getBean(name) instanceof Supplier) {
            this.supplier = (Supplier)this.getAndInstrumentFromContext(name);
            return;
        }
    }

    private void initFunctionConsumerOrSupplierFromCatalog(Object targetContext) {
        String name = this.resolveName(Function.class, targetContext);
        this.function = (Function)this.catalog.lookup(Function.class, name);
        if (this.function != null) {
            return;
        }
        name = this.resolveName(Consumer.class, targetContext);
        this.consumer = (Consumer)this.catalog.lookup(Consumer.class, name);
        if (this.consumer != null) {
            return;
        }
        name = this.resolveName(Supplier.class, targetContext);
        this.supplier = (Supplier)this.catalog.lookup(Supplier.class, name);
        if (this.supplier != null) {
            return;
        }
        if (this.catalog.size() >= 1 && this.catalog.size() <= 2) {
            String functionName = this.catalog.getNames(Function.class).stream().filter(n -> !n.equals("functionRouter")).findFirst().orElseGet(() -> null);
            if (functionName != null) {
                this.function = (Function)this.catalog.lookup(Function.class, functionName);
                return;
            }
            functionName = this.catalog.getNames(Supplier.class).stream().findFirst().orElseGet(() -> null);
            if (functionName != null) {
                this.supplier = (Supplier)this.catalog.lookup(Supplier.class, functionName);
                return;
            }
            functionName = this.catalog.getNames(Consumer.class).stream().findFirst().orElseGet(() -> null);
            if (functionName != null) {
                this.consumer = (Consumer)this.catalog.lookup(Consumer.class, functionName);
                return;
            }
        } else {
            name = this.doResolveName(targetContext);
            this.function = (Function)this.catalog.lookup(Function.class, name);
            if (this.function != null) {
                return;
            }
            this.consumer = (Consumer)this.catalog.lookup(Consumer.class, name);
            if (this.consumer != null) {
                return;
            }
            this.supplier = (Supplier)this.catalog.lookup(Supplier.class, name);
            if (this.supplier != null) {
                return;
            }
        }
    }

    private SpringApplication springApplication() {
        Class<?> sourceClass = this.configurationClass;
        FunctionalSpringApplication application = new FunctionalSpringApplication(sourceClass);
        application.setWebApplicationType(WebApplicationType.NONE);
        return application;
    }
}

