/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.azure;

import com.microsoft.azure.functions.spi.inject.FunctionInstanceInjector;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.ResourceBanner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.CollectionUtils;

public class AzureFunctionInstanceInjector
implements FunctionInstanceInjector {
    private static Log logger = LogFactory.getLog(AzureFunctionInstanceInjector.class);
    private static ConfigurableApplicationContext APPLICATION_CONTEXT;
    private static final ReentrantLock globalLock;

    public <T> T getInstance(Class<T> functionClass) throws Exception {
        try {
            AzureFunctionInstanceInjector.initialize();
            Map azureFunctionBean = APPLICATION_CONTEXT.getBeansOfType(functionClass);
            if (CollectionUtils.isEmpty((Map)azureFunctionBean)) {
                throw new IllegalStateException("Failed to retrieve Bean instance for: " + String.valueOf(functionClass) + ". The class should be annotated with @Component to let the Spring framework initialize it!");
            }
            return (T)azureFunctionBean.entrySet().iterator().next().getValue();
        }
        catch (Exception e) {
            if (APPLICATION_CONTEXT != null) {
                APPLICATION_CONTEXT.close();
            }
            throw new IllegalStateException("Failed to initialize", e);
        }
    }

    private static void initialize() {
        if (APPLICATION_CONTEXT == null) {
            try {
                globalLock.lock();
                if (APPLICATION_CONTEXT == null) {
                    Class springConfigurationClass = FunctionClassUtils.getStartClass();
                    logger.info((Object)("Initializing: " + String.valueOf(springConfigurationClass)));
                    APPLICATION_CONTEXT = AzureFunctionInstanceInjector.springApplication(springConfigurationClass).run(new String[0]);
                }
            }
            finally {
                globalLock.unlock();
            }
        }
    }

    private static SpringApplication springApplication(Class<?> configurationClass) {
        FunctionalSpringApplication application = new FunctionalSpringApplication(new Class[]{configurationClass});
        application.setWebApplicationType(WebApplicationType.NONE);
        application.setBanner((Banner)new ResourceBanner(new DefaultResourceLoader().getResource("classpath:/spring-azure-function-banner.txt")));
        return application;
    }

    static {
        globalLock = new ReentrantLock();
    }
}

