/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.azure.web;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.azure.functions.annotation.AuthorizationLevel;
import com.microsoft.azure.functions.annotation.FunctionName;
import com.microsoft.azure.functions.annotation.HttpTrigger;
import com.microsoft.azure.functions.spi.inject.FunctionInstanceInjector;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.serverless.web.ServerlessHttpServletRequest;
import org.springframework.cloud.function.serverless.web.ServerlessHttpServletResponse;
import org.springframework.cloud.function.serverless.web.ServerlessMVC;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AzureWebProxyInvoker
implements FunctionInstanceInjector {
    private static Log logger = LogFactory.getLog(AzureWebProxyInvoker.class);
    private static final String AZURE_WEB_ADAPTER_NAME = "AzureWebAdapter";
    private static final String AZURE_WEB_ADAPTER_ROUTE = "AzureWebAdapter/{e?}/{e2?}/{e3?}/{e4?}/{e5?}/{e6?}/{e7?}/{e8?}/{e9?}/{e10?}/{e11?}/{e12?}/{e13?}/{e14?}/{e15?}";
    private ServerlessMVC mvc;
    private ServletContext servletContext;
    private static final ReentrantLock globalLock = new ReentrantLock();

    public <T> T getInstance(Class<T> functionClass) throws Exception {
        this.initialize();
        return (T)this;
    }

    private void initialize() throws ServletException {
        if (this.mvc == null) {
            try {
                globalLock.lock();
                if (this.mvc == null) {
                    Class startClass = FunctionClassUtils.getStartClass();
                    this.mvc = ServerlessMVC.INSTANCE((Class[])new Class[]{startClass});
                }
            }
            finally {
                globalLock.unlock();
            }
        }
    }

    private HttpServletRequest prepareRequest(HttpRequestMessage<Optional<String>> request) {
        int pathOffset = request.getUri().getPath().indexOf(AZURE_WEB_ADAPTER_NAME) + AZURE_WEB_ADAPTER_NAME.length();
        String path = request.getUri().getPath().substring(pathOffset);
        ServerlessHttpServletRequest httpRequest = new ServerlessHttpServletRequest(this.servletContext, request.getHttpMethod().toString(), path);
        ((Optional)request.getBody()).ifPresent(body -> {
            Charset charsetEncoding = request.getHeaders() != null && request.getHeaders().containsKey("content-encoding") ? Charset.forName((String)request.getHeaders().get("content-encoding")) : StandardCharsets.UTF_8;
            httpRequest.setContent(body.getBytes(charsetEncoding));
        });
        if (!CollectionUtils.isEmpty((Map)request.getQueryParameters())) {
            httpRequest.setParameters(request.getQueryParameters());
        }
        if (!CollectionUtils.isEmpty((Map)request.getHeaders())) {
            for (Map.Entry entry : request.getHeaders().entrySet()) {
                httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return httpRequest;
    }

    @FunctionName(value="AzureWebAdapter")
    public HttpResponseMessage execute(@HttpTrigger(name="req", methods={HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.PATCH}, authLevel=AuthorizationLevel.ANONYMOUS, route="AzureWebAdapter/{e?}/{e2?}/{e3?}/{e4?}/{e5?}/{e6?}/{e7?}/{e8?}/{e9?}/{e10?}/{e11?}/{e12?}/{e13?}/{e14?}/{e15?}") HttpRequestMessage<Optional<String>> request, ExecutionContext context) {
        context.getLogger().info("Request body is: " + ((Optional)request.getBody()).orElse("[empty]"));
        HttpServletRequest httpRequest = this.prepareRequest(request);
        ServerlessHttpServletResponse httpResponse = new ServerlessHttpServletResponse();
        try {
            this.mvc.service(httpRequest, (HttpServletResponse)httpResponse);
            HttpStatus status = HttpStatus.valueOf((int)httpResponse.getStatus());
            HttpResponseMessage.Builder responseBuilder = request.createResponseBuilder(status);
            for (String headerName : httpResponse.getHeaderNames()) {
                responseBuilder.header(headerName, httpResponse.getHeader(headerName));
            }
            String responseString = httpResponse.getContentAsString(StandardCharsets.UTF_8);
            if (StringUtils.hasText((String)responseString)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Response: " + responseString));
                }
                responseBuilder.body((Object)responseString);
            }
            return responseBuilder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }
}

