/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import org.springframework.cloud.deployer.spi.yarn.YarnCloudAppService;
import org.springframework.cloud.deployer.spi.yarn.YarnDeployerProperties;
import org.springframework.core.io.Resource;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SettableListenableFuture;

public class YarnTaskLauncher
implements TaskLauncher {
    private static final Logger logger = LoggerFactory.getLogger(YarnTaskLauncher.class);
    private final YarnCloudAppService yarnCloudAppService;
    private final StateMachine<String, String> stateMachine;
    @Autowired
    private YarnDeployerProperties yarnDeployerProperties;

    public YarnTaskLauncher(YarnCloudAppService yarnCloudAppService, StateMachine<String, String> stateMachine) {
        this.yarnCloudAppService = yarnCloudAppService;
        this.stateMachine = stateMachine;
    }

    public String launch(AppDeploymentRequest request) {
        String appVersion;
        logger.info("Deploy request for {}", (Object)request);
        logger.info("Deploy request deployment properties {}", (Object)request.getDeploymentProperties());
        logger.info("Deploy definition {}", (Object)request.getDefinition());
        Resource resource = request.getResource();
        AppDefinition definition = request.getDefinition();
        String artifact = resource.getFilename();
        final String name = definition.getName();
        Map definitionParameters = definition.getProperties();
        Map deploymentProperties = request.getDeploymentProperties();
        List commandlineArguments = request.getCommandlineArguments();
        String appName = "scdtask:" + name;
        ArrayList<String> contextRunArgs = new ArrayList<String>();
        contextRunArgs.add("--spring.yarn.appName=" + appName);
        for (Map.Entry entry : definitionParameters.entrySet()) {
            if (!StringUtils.hasText((String)((String)entry.getValue()))) continue;
            contextRunArgs.add("--spring.yarn.client.launchcontext.arguments.--spring.cloud.deployer.yarn.appmaster.parameters." + (String)entry.getKey() + ".='" + (String)entry.getValue() + "'");
        }
        int index = 0;
        for (String commandlineArgument : commandlineArguments) {
            contextRunArgs.add("--spring.yarn.client.launchcontext.argumentsList[" + index + "]='--spring.cloud.deployer.yarn.appmaster.commandlineArguments[" + index + "]=" + commandlineArgument + "'");
            ++index;
        }
        String baseDir = this.yarnDeployerProperties.getBaseDir();
        if (!baseDir.endsWith("/")) {
            baseDir = baseDir + "/";
        }
        String artifactPath = this.isHdfsResource(resource) ? this.getHdfsArtifactPath(resource) : baseDir + "/artifacts/cache/";
        contextRunArgs.add("--spring.yarn.client.launchcontext.arguments.--spring.yarn.appmaster.launchcontext.archiveFile=" + artifact);
        contextRunArgs.add("--spring.yarn.client.launchcontext.arguments.--spring.cloud.deployer.yarn.appmaster.artifact=" + artifactPath + artifact);
        for (Map.Entry entry : deploymentProperties.entrySet()) {
            if (!StringUtils.hasText((String)((String)entry.getValue()))) continue;
            if (((String)entry.getKey()).startsWith("spring.cloud.deployer.yarn.app.taskcontainer")) {
                contextRunArgs.add("--spring.yarn.client.launchcontext.arguments.--" + (String)entry.getKey() + "='" + (String)entry.getValue() + "'");
                continue;
            }
            if (!((String)entry.getKey()).startsWith("spring.cloud.deployer.yarn.app.taskappmaster")) continue;
            contextRunArgs.add("--" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        String string = appVersion = StringUtils.hasText((String)this.yarnDeployerProperties.getAppVersion()) ? this.yarnDeployerProperties.getAppVersion() : "app";
        if (deploymentProperties.containsKey("spring.cloud.deployer.yarn.app.appVersion")) {
            appVersion = (String)deploymentProperties.get("spring.cloud.deployer.yarn.app.appVersion");
        }
        final Message message = MessageBuilder.withPayload((Object)"LAUNCH").setHeader("appVersion", (Object)appVersion).setHeader("artifact", (Object)resource).setHeader("artifactDir", (Object)artifactPath).setHeader("definitionParameters", (Object)definitionParameters).setHeader("contextRunArgs", contextRunArgs).build();
        final SettableListenableFuture id = new SettableListenableFuture();
        StateMachineListenerAdapter<String, String> listener = new StateMachineListenerAdapter<String, String>(){

            public void stateContext(StateContext<String, String> stateContext) {
                if (stateContext.getStage() == StateContext.Stage.STATE_ENTRY && ((String)stateContext.getTarget().getId()).equals("READY") && ObjectUtils.nullSafeEquals((Object)message.getHeaders().getId().toString(), (Object)stateContext.getExtendedState().get((Object)"messageId", String.class))) {
                    Exception exception = (Exception)stateContext.getExtendedState().get((Object)"error", Exception.class);
                    if (exception != null) {
                        id.setException((Throwable)exception);
                    } else {
                        String applicationId = (String)stateContext.getStateMachine().getExtendedState().get((Object)"applicationId", String.class);
                        DeploymentKey key = new DeploymentKey(name, applicationId);
                        id.set((Object)key.toString());
                    }
                }
            }
        };
        this.stateMachine.addStateListener((StateMachineListener)listener);
        id.addCallback((ListenableFutureCallback)new ListenableFutureCallback<String>((StateMachineListener)listener){
            final /* synthetic */ StateMachineListener val$listener;
            {
                this.val$listener = stateMachineListener;
            }

            public void onSuccess(String result) {
                YarnTaskLauncher.this.stateMachine.removeStateListener(this.val$listener);
            }

            public void onFailure(Throwable ex) {
                YarnTaskLauncher.this.stateMachine.removeStateListener(this.val$listener);
            }
        });
        this.stateMachine.sendEvent(message);
        try {
            return (String)id.get(2L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isHdfsResource(Resource resource) {
        try {
            return resource != null && resource.getURI().getScheme().equals("hdfs");
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getHdfsArtifactPath(Resource resource) {
        String path = null;
        try {
            path = "/" + FilenameUtils.getPath((String)resource.getURI().getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public void cancel(String id) {
        logger.info("Undeploy request for task {}", (Object)id);
        DeploymentKey key = new DeploymentKey(id);
        Message message = MessageBuilder.withPayload((Object)"CANCEL").setHeader("applicationId", (Object)key.applicationId).build();
        this.stateMachine.sendEvent(message);
    }

    public TaskStatus status(String id) {
        logger.info("Status request for module {}", (Object)id);
        DeploymentKey key = new DeploymentKey(id);
        Collection<YarnCloudAppService.CloudAppInstanceInfo> instances = this.yarnCloudAppService.getInstances(YarnCloudAppService.CloudAppType.TASK);
        for (YarnCloudAppService.CloudAppInstanceInfo instance : instances) {
            if (!instance.getApplicationId().equals(key.applicationId) || instance.getState() != "RUNNING") continue;
            return new TaskStatus(id, LaunchState.running, null);
        }
        return new TaskStatus(id, LaunchState.unknown, null);
    }

    public void cleanup(String id) {
    }

    public void destroy(String appName) {
    }

    private static class DeploymentKey {
        static final String SEPARATOR = ":";
        final String name;
        final String applicationId;

        public DeploymentKey(String id) {
            String[] split = id.split(SEPARATOR);
            Assert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)("Unable to parse deployment key " + id));
            this.name = split[0];
            this.applicationId = split[1];
        }

        public DeploymentKey(String name, String applicationId) {
            Assert.notNull((Object)name, (String)"Name must be set");
            Assert.notNull((Object)applicationId, (String)"Application id must be set");
            this.name = name;
            this.applicationId = applicationId;
        }

        public String toString() {
            return this.name + SEPARATOR + this.applicationId;
        }
    }
}

