/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn.appdeployer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.yarn.appdeployer.StreamAppmaster;
import org.springframework.cloud.deployer.spi.yarn.appdeployer.StreamAppmasterProperties;
import org.springframework.util.StringUtils;
import org.springframework.yarn.am.ContainerLauncherInterceptor;
import org.springframework.yarn.am.cluster.ContainerCluster;
import org.springframework.yarn.am.cluster.ManagedContainerClusterAppmaster;
import org.springframework.yarn.am.container.AbstractLauncher;
import org.springframework.yarn.am.grid.GridMember;
import org.springframework.yarn.am.grid.support.ProjectionData;
import org.springframework.yarn.fs.LocalResourcesFactoryBean;
import org.springframework.yarn.fs.ResourceLocalizer;
import org.springframework.yarn.listener.ContainerMonitorListener;

public class StreamAppmaster
extends ManagedContainerClusterAppmaster {
    private static final Log log = LogFactory.getLog(StreamAppmaster.class);
    private final Map<String, ResourceLocalizer> artifactLocalizers = new HashMap();
    private final ContainerIndexTracker indexTracker = new ContainerIndexTracker(null);
    private final Map<ContainerId, String> containerIdMap = new HashMap();
    @Autowired
    private StreamAppmasterProperties streamAppmasterProperties;

    protected void onInit() throws Exception {
        super.onInit();
        this.getMonitor().addContainerMonitorStateListener((ContainerMonitorListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.getLauncher() instanceof AbstractLauncher) {
            ((AbstractLauncher)this.getLauncher()).addInterceptor((ContainerLauncherInterceptor)new IndexAddingContainerLauncherInterceptor(this, null));
        }
    }

    public ContainerCluster createContainerCluster(String clusterId, String clusterDef, ProjectionData projectionData, Map<String, Object> extraProperties) {
        log.info((Object)("intercept createContainerCluster " + clusterId));
        String artifactPath = this.streamAppmasterProperties.getArtifact();
        try {
            LocalResourcesFactoryBean lrfb = new LocalResourcesFactoryBean();
            lrfb.setConfiguration(this.getConfiguration());
            String containerArtifact = (String)extraProperties.get("containerArtifact");
            LocalResourcesFactoryBean.TransferEntry te = new LocalResourcesFactoryBean.TransferEntry(LocalResourceType.FILE, null, artifactPath + "/" + containerArtifact, false);
            ArrayList<LocalResourcesFactoryBean.TransferEntry> hdfsEntries = new ArrayList<LocalResourcesFactoryBean.TransferEntry>();
            hdfsEntries.add(te);
            lrfb.setHdfsEntries(hdfsEntries);
            lrfb.setCopyEntries(new ArrayList());
            lrfb.afterPropertiesSet();
            ResourceLocalizer rl = lrfb.getObject();
            log.info((Object)("Adding localizer for " + clusterId + " / " + rl));
            this.artifactLocalizers.put(clusterId, rl);
        }
        catch (Exception e) {
            log.error((Object)"Error creating localizer", (Throwable)e);
        }
        return super.createContainerCluster(clusterId, clusterDef, projectionData, extraProperties);
    }

    protected List<String> onContainerLaunchCommands(Container container, ContainerCluster cluster, List<String> commands) {
        log.info((Object)("onContainerLaunchCommands commands=" + StringUtils.collectionToCommaDelimitedString(commands)));
        ArrayList<String> list = new ArrayList<String>();
        Map extraProperties = cluster.getExtraProperties();
        String artifact = (String)extraProperties.get("containerArtifact");
        for (String string : commands) {
            if (string.contains("placeholder.jar")) {
                list.add(string.replace("placeholder.jar", artifact));
                continue;
            }
            list.add(string);
        }
        if (extraProperties != null) {
            for (Map.Entry entry : extraProperties.entrySet()) {
                if (!((String)entry.getKey()).startsWith("containerArg")) continue;
                log.info((Object)("onContainerLaunchCommands adding command=--" + entry.getValue().toString()));
                list.add(Math.max(list.size() - 2, 0), "--" + entry.getValue().toString());
            }
        }
        return list;
    }

    protected Map<String, LocalResource> buildLocalizedResources(ContainerCluster cluster) {
        Map resources = super.buildLocalizedResources(cluster);
        ResourceLocalizer rl = (ResourceLocalizer)this.artifactLocalizers.get(cluster.getId());
        log.info((Object)("Localizer for " + cluster.getId() + " is " + rl));
        resources.putAll(rl.getResources());
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onContainerCompleted(ContainerStatus status) {
        super.onContainerCompleted(status);
        String containerClusterId = (String)this.containerIdMap.get(status.getContainerId());
        if (containerClusterId != null) {
            ContainerIndexTracker containerIndexTracker = this.indexTracker;
            synchronized (containerIndexTracker) {
                this.indexTracker.freeIndex(status.getContainerId(), containerClusterId);
            }
        }
    }

    private ContainerCluster findContainerClusterByContainerId(ContainerId containerId) {
        for (Map.Entry entry : this.getContainerClusters().entrySet()) {
            for (GridMember member : ((ContainerCluster)entry.getValue()).getGridProjection().getMembers()) {
                if (!member.getId().equals((Object)containerId)) continue;
                return (ContainerCluster)entry.getValue();
            }
        }
        return null;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    static /* synthetic */ void access$200(StreamAppmaster x0) {
        x0.notifyCompleted();
    }

    static /* synthetic */ ContainerCluster access$400(StreamAppmaster x0, ContainerId x1) {
        return x0.findContainerClusterByContainerId(x1);
    }

    static /* synthetic */ Map access$500(StreamAppmaster x0) {
        return x0.containerIdMap;
    }

    static /* synthetic */ ContainerIndexTracker access$600(StreamAppmaster x0) {
        return x0.indexTracker;
    }
}

