/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class AppDeploymentRequest {
    private final AppDefinition definition;
    private final Resource resource;
    private final Map<String, String> deploymentProperties;
    private final List<String> commandlineArguments;

    public AppDeploymentRequest(AppDefinition definition, Resource resource, Map<String, String> deploymentProperties) {
        this(definition, resource, deploymentProperties, null);
    }

    public AppDeploymentRequest(AppDefinition definition, Resource resource, Map<String, String> deploymentProperties, List<String> commandlineArguments) {
        Assert.notNull((Object)definition, (String)"definition must not be null");
        Assert.notNull((Object)resource, (String)"resource must not be null");
        this.definition = definition;
        this.resource = resource;
        this.deploymentProperties = deploymentProperties == null ? Collections.emptyMap() : Collections.unmodifiableMap(deploymentProperties);
        this.commandlineArguments = commandlineArguments == null ? Collections.emptyList() : Collections.unmodifiableList(commandlineArguments);
    }

    public AppDeploymentRequest(AppDefinition definition, Resource resource) {
        this(definition, resource, null);
    }

    public AppDefinition getDefinition() {
        return this.definition;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Map<String, String> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public List<String> getCommandlineArguments() {
        return this.commandlineArguments;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("commandlineArguments", this.commandlineArguments).append("deploymentProperties", this.deploymentProperties).append("definition", (Object)this.definition).append("resource", (Object)this.resource).toString();
    }
}

