/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.app;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.app.ActuatorOperations;
import org.springframework.cloud.deployer.spi.app.AppAdmin;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractActuatorTemplate
implements ActuatorOperations {
    protected final Log logger = LogFactory.getLog((String)this.getClass().getName());
    protected final RestTemplate restTemplate;
    protected final AppDeployer appDeployer;
    private final AppAdmin appAdmin;
    private final Optional<String> defaultAuthenticationHeaderValue;

    protected AbstractActuatorTemplate(RestTemplate restTemplate, AppDeployer appDeployer, AppAdmin appAdmin) {
        Assert.notNull((Object)restTemplate, (String)"'restTemplate' is required.");
        Assert.notNull((Object)appDeployer, (String)"'appDeployer' is required.");
        Assert.notNull((Object)appAdmin, (String)"'appAdmin' is required.");
        this.restTemplate = restTemplate;
        this.appDeployer = appDeployer;
        this.appAdmin = appAdmin;
        this.defaultAuthenticationHeaderValue = this.prepareDefaultAthentication(appAdmin);
    }

    @Override
    public <T> T getFromActuator(String deploymentId, String guid, String endpoint, Class<T> responseType, Optional<HttpHeaders> optionalRequestHeaders) {
        AppInstanceStatus appInstanceStatus = this.getDeployedInstance(deploymentId, guid).orElseThrow(() -> new IllegalStateException(String.format("App with deploymentId %s and guid %s not deployed", deploymentId, guid)));
        String actuatorUrl = this.getActuatorUrl(appInstanceStatus);
        HttpHeaders requestHeaders = this.requestHeaders(this.httpHeadersForInstance(appInstanceStatus), optionalRequestHeaders);
        ResponseEntity<T> responseEntity = this.httpGet(UriComponentsBuilder.fromHttpUrl((String)actuatorUrl).path(this.normalizePath(endpoint)).toUriString(), responseType, requestHeaders);
        if (responseEntity.getStatusCode().isError()) {
            this.logger.error((Object)responseEntity.getStatusCode().toString());
        }
        return (T)responseEntity.getBody();
    }

    @Override
    public <T, R> R postToActuator(String deploymentId, String guid, String endpoint, T body, Class<R> responseType, Optional<HttpHeaders> optionalRequestHeaders) {
        AppInstanceStatus appInstanceStatus = this.getDeployedInstance(deploymentId, guid).orElseThrow(() -> new IllegalStateException(String.format("App with deploymentId %s and guid %s not deployed", deploymentId, guid)));
        String actuatorUrl = this.getActuatorUrl(appInstanceStatus);
        HttpHeaders requestHeaders = this.requestHeaders(this.httpHeadersForInstance(appInstanceStatus), optionalRequestHeaders);
        ResponseEntity<R> responseEntity = this.httpPost(UriComponentsBuilder.fromHttpUrl((String)actuatorUrl).path(this.normalizePath(endpoint)).toUriString(), body, responseType, requestHeaders);
        if (responseEntity.getStatusCode().isError()) {
            this.logger.error((Object)responseEntity.getStatusCode().toString());
        }
        return (R)responseEntity.getBody();
    }

    protected final String getActuatorUrl(AppInstanceStatus appInstanceStatus) {
        try {
            return this.actuatorUrlForInstance(appInstanceStatus);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unable to determine actuator url for app with guid %s", appInstanceStatus.getAttributes().get("guid")));
        }
    }

    protected abstract String actuatorUrlForInstance(AppInstanceStatus var1);

    protected Optional<HttpHeaders> httpHeadersForInstance(AppInstanceStatus appInstanceStatus) {
        return Optional.empty();
    }

    private final HttpHeaders requestHeaders(Optional<HttpHeaders> optionalAppInstanceHeaders, Optional<HttpHeaders> optionalRequestHeaders) {
        HttpHeaders requestHeaders = optionalAppInstanceHeaders.orElse(new HttpHeaders());
        optionalRequestHeaders.ifPresent(arg_0 -> ((HttpHeaders)requestHeaders).addAll(arg_0));
        if (!requestHeaders.containsKey((Object)"Authorization")) {
            this.defaultAuthenticationHeaderValue.ifPresent(auth -> requestHeaders.setBasicAuth(auth));
        }
        requestHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        requestHeaders.setContentType(MediaType.APPLICATION_JSON);
        return requestHeaders;
    }

    private final String normalizePath(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    private final <T> ResponseEntity<T> httpGet(String url, Class<T> responseType, HttpHeaders requestHeaders) {
        return this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)requestHeaders), responseType, new Object[0]);
    }

    private final <T, R> ResponseEntity<R> httpPost(String url, T requestBody, Class<R> responseType, HttpHeaders requestHeaders) {
        return this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(requestBody, (MultiValueMap)requestHeaders), responseType, new Object[0]);
    }

    private final Optional<AppInstanceStatus> getDeployedInstance(String deploymentId, String guid) {
        AppStatus appStatus = this.appDeployer.status(deploymentId);
        long count = appStatus.getInstances().values().stream().filter(appInstance -> appInstance.getAttributes().get("guid").equals(guid)).count();
        if (count == 0L) {
            return Optional.empty();
        }
        if (count > 1L) {
            throw new IllegalStateException(String.format("guid %s is not unique for instances of deploymentId %s", guid, deploymentId));
        }
        return appStatus.getInstances().values().stream().filter(appInstance -> appInstance.getState() == DeploymentState.deployed && appInstance.getAttributes().get("guid").equals(guid)).findFirst();
    }

    private Optional<String> prepareDefaultAthentication(AppAdmin appAdmin) {
        Optional<String> encodeBasicAuth;
        Optional<String> optional = encodeBasicAuth = appAdmin.hasCredentials() ? Optional.of(HttpHeaders.encodeBasicAuth((String)appAdmin.getUser(), (String)appAdmin.getPassword(), (Charset)Charset.defaultCharset())) : Optional.empty();
        if (!encodeBasicAuth.isPresent()) {
            this.logger.warn((Object)("No app admin credentials have been configured for " + this.getClass().getName()));
        }
        return encodeBasicAuth;
    }
}

