/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.util.Assert;

public class AppStatus {
    private final String deploymentId;
    private final Map<String, AppInstanceStatus> instances = new HashMap<String, AppInstanceStatus>();
    private final DeploymentState generalState;

    protected AppStatus(String deploymentId, DeploymentState generalState) {
        this.deploymentId = deploymentId;
        this.generalState = generalState;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public DeploymentState getState() {
        if (this.generalState != null) {
            return this.generalState;
        }
        HashSet<DeploymentState> states = new HashSet<DeploymentState>();
        for (Map.Entry<String, AppInstanceStatus> entry : this.instances.entrySet()) {
            states.add(entry.getValue().getState());
        }
        if (states.size() == 0) {
            return DeploymentState.unknown;
        }
        if (states.size() == 1) {
            return (DeploymentState)((Object)states.iterator().next());
        }
        if (states.contains((Object)DeploymentState.error)) {
            return DeploymentState.error;
        }
        if (states.contains((Object)DeploymentState.deploying)) {
            return DeploymentState.deploying;
        }
        if (states.contains((Object)DeploymentState.deployed) || states.contains((Object)DeploymentState.partial)) {
            return DeploymentState.partial;
        }
        if (states.contains((Object)DeploymentState.failed)) {
            return DeploymentState.failed;
        }
        return DeploymentState.partial;
    }

    public String toString() {
        return this.getState().name();
    }

    public Map<String, AppInstanceStatus> getInstances() {
        return Collections.unmodifiableMap(this.instances);
    }

    private void addInstance(String id, AppInstanceStatus status) {
        this.instances.put(id, status);
    }

    public static Builder of(String id) {
        return new Builder(id);
    }

    public static class Builder {
        private final String id;
        private DeploymentState generalState;
        private List<AppInstanceStatus> statuses = new ArrayList<AppInstanceStatus>();

        private Builder(String id) {
            this.id = id;
        }

        public Builder with(AppInstanceStatus instance) {
            Assert.isNull((Object)((Object)this.generalState), (String)"Can't build an AppStatus from app instances if generalState has been set");
            this.statuses.add(instance);
            return this;
        }

        public Builder generalState(DeploymentState generalState) {
            Assert.isTrue((boolean)this.statuses.isEmpty(), (String)"Can't build an AppStatus from general state if some instances have been added");
            this.generalState = generalState;
            return this;
        }

        public AppStatus build() {
            AppStatus status = new AppStatus(this.id, this.generalState);
            for (AppInstanceStatus instanceStatus : this.statuses) {
                status.addInstance(instanceStatus.getId(), instanceStatus);
            }
            return status;
        }
    }
}

