/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.app;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;

public class AppStatus {
    private final String deploymentId;
    private final Map<String, AppInstanceStatus> instances = new HashMap<String, AppInstanceStatus>();

    protected AppStatus(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public DeploymentState getState() {
        HashSet<DeploymentState> states = new HashSet<DeploymentState>();
        for (Map.Entry<String, AppInstanceStatus> entry : this.instances.entrySet()) {
            states.add(entry.getValue().getState());
        }
        if (states.size() == 0) {
            return DeploymentState.unknown;
        }
        if (states.size() == 1) {
            return (DeploymentState)((Object)states.iterator().next());
        }
        if (states.contains((Object)DeploymentState.error)) {
            return DeploymentState.error;
        }
        if (states.contains((Object)DeploymentState.deploying)) {
            return DeploymentState.deploying;
        }
        if (states.contains((Object)DeploymentState.deployed) || states.contains((Object)DeploymentState.partial)) {
            return DeploymentState.partial;
        }
        if (states.contains((Object)DeploymentState.failed)) {
            return DeploymentState.failed;
        }
        return DeploymentState.partial;
    }

    public String toString() {
        return this.getState().name();
    }

    public Map<String, AppInstanceStatus> getInstances() {
        return Collections.unmodifiableMap(this.instances);
    }

    private void addInstance(String id, AppInstanceStatus status) {
        this.instances.put(id, status);
    }

    public static Builder of(String id) {
        return new Builder(id);
    }

    public static class Builder {
        private final AppStatus status;

        private Builder(String id) {
            this.status = new AppStatus(id);
        }

        public Builder with(AppInstanceStatus instance) {
            this.status.addInstance(instance.getId(), instance);
            return this;
        }

        public AppStatus build() {
            return this.status;
        }
    }
}

