/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.test;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import org.springframework.cloud.deployer.spi.test.AbstractIntegrationJUnit5Tests;
import org.springframework.cloud.deployer.spi.test.Timeout;
import org.springframework.core.io.Resource;

public abstract class AbstractTaskLauncherIntegrationJUnit5Tests
extends AbstractIntegrationJUnit5Tests {
    private TaskLauncherWrapper launcherWrapper;

    protected abstract TaskLauncher provideTaskLauncher();

    protected TaskLauncher taskLauncher() {
        return this.launcherWrapper;
    }

    @BeforeEach
    public void wrapDeployer() {
        this.launcherWrapper = new TaskLauncherWrapper(this.provideTaskLauncher());
    }

    @AfterEach
    public void cleanupLingeringApps() {
        for (String id : this.launcherWrapper.launchedTasks) {
            try {
                this.launcherWrapper.wrapped.cleanup(id);
            }
            catch (Exception e) {
                this.log.warn("Exception caught while trying to cleanup '{}'. Moving on...", (Object)id);
            }
        }
        for (String appName : this.launcherWrapper.deployedApps) {
            try {
                this.log.warn("Test named '{}' left behind an app for ''. Trying to destroy.", (Object)this.testName, (Object)appName);
                this.launcherWrapper.wrapped.destroy(appName);
            }
            catch (Exception e) {
                this.log.warn("Exception caught while trying to destroy '{}'. Moving on...", (Object)appName);
            }
        }
    }

    @Test
    public void testNonExistentAppsStatus() {
        Assertions.assertThat((Comparable)this.taskLauncher().status(this.randomName()).getState()).isEqualTo((Object)LaunchState.unknown);
    }

    @Test
    public void testSimpleLaunch() throws InterruptedException {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("killDelay", "0");
        appProperties.put("exitCode", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String launchId = this.taskLauncher().launch(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.totalTime)).untilAsserted(() -> Assertions.assertThat((Comparable)this.taskLauncher().status(launchId).getState()).isEqualTo((Object)LaunchState.complete));
        this.taskLauncher().destroy(definition.getName());
    }

    @Test
    public void testReLaunch() throws InterruptedException {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("killDelay", "0");
        appProperties.put("exitCode", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String launchId = this.taskLauncher().launch(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.totalTime)).untilAsserted(() -> Assertions.assertThat((Comparable)this.taskLauncher().status(launchId).getState()).isEqualTo((Object)LaunchState.complete));
        this.log.info("Re-Launching {}...", (Object)request.getDefinition().getName());
        String newLaunchId = this.taskLauncher().launch(request);
        Assertions.assertThat((String)newLaunchId).isNotEqualTo((Object)launchId);
        timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.totalTime)).untilAsserted(() -> Assertions.assertThat((Comparable)this.taskLauncher().status(newLaunchId).getState()).isEqualTo((Object)LaunchState.complete));
        this.taskLauncher().destroy(definition.getName());
    }

    @Test
    public void testErrorExit() throws InterruptedException {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("killDelay", "0");
        appProperties.put("exitCode", "1");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String launchId = this.taskLauncher().launch(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.totalTime)).untilAsserted(() -> Assertions.assertThat((Comparable)this.taskLauncher().status(launchId).getState()).isEqualTo((Object)LaunchState.failed));
        this.taskLauncher().destroy(definition.getName());
    }

    @Test
    public void testSimpleCancel() throws InterruptedException {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("killDelay", "-1");
        appProperties.put("exitCode", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String launchId = this.taskLauncher().launch(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.totalTime)).untilAsserted(() -> Assertions.assertThat((Comparable)this.taskLauncher().status(launchId).getState()).isEqualTo((Object)LaunchState.running));
        this.log.info("Cancelling {}...", (Object)request.getDefinition().getName());
        this.taskLauncher().cancel(launchId);
        timeout = this.undeploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.totalTime)).untilAsserted(() -> Assertions.assertThat((Comparable)this.taskLauncher().status(launchId).getState()).isEqualTo((Object)LaunchState.cancelled));
        this.taskLauncher().destroy(definition.getName());
    }

    @Test
    public void testCommandLineArgs() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("killDelay", "1000");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, Collections.emptyMap(), Collections.singletonList("--exitCode=0"));
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.taskLauncher().launch(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.totalTime)).untilAsserted(() -> Assertions.assertThat((Comparable)this.taskLauncher().status(deploymentId).getState()).isEqualTo((Object)LaunchState.complete));
        this.taskLauncher().destroy(definition.getName());
    }

    @Test
    public void testEnvironmentInfo() {
        RuntimeEnvironmentInfo info = this.taskLauncher().environmentInfo();
        Assertions.assertThat((String)info.getImplementationVersion()).isNotNull();
        Assertions.assertThat((String)info.getPlatformType()).isNotNull();
        Assertions.assertThat((String)info.getPlatformClientVersion()).isNotNull();
        Assertions.assertThat((String)info.getPlatformHostVersion()).isNotNull();
    }

    protected static class TaskLauncherWrapper
    implements TaskLauncher {
        private final TaskLauncher wrapped;
        private final Set<String> deployedApps = new LinkedHashSet<String>();
        private final Set<String> launchedTasks = new LinkedHashSet<String>();

        public TaskLauncherWrapper(TaskLauncher wrapped) {
            this.wrapped = wrapped;
        }

        public String launch(AppDeploymentRequest request) {
            String launchId = this.wrapped.launch(request);
            this.deployedApps.add(request.getDefinition().getName());
            this.launchedTasks.add(launchId);
            return launchId;
        }

        public void cancel(String id) {
            this.wrapped.cancel(id);
        }

        public TaskStatus status(String id) {
            return this.wrapped.status(id);
        }

        public void cleanup(String id) {
            this.wrapped.cleanup(id);
            this.launchedTasks.remove(id);
        }

        public void destroy(String appName) {
            this.wrapped.destroy(appName);
            this.deployedApps.remove(appName);
        }

        public RuntimeEnvironmentInfo environmentInfo() {
            return this.wrapped.environmentInfo();
        }

        public int getMaximumConcurrentTasks() {
            return this.wrapped.getMaximumConcurrentTasks();
        }

        public int getRunningTaskExecutionCount() {
            return this.wrapped.getRunningTaskExecutionCount();
        }

        public String getLog(String id) {
            return this.wrapped.getLog(id);
        }
    }

    protected static class TaskLauncherAssert
    extends AbstractAssert<TaskLauncherAssert, TaskLauncher> {
        public TaskLauncherAssert(TaskLauncher launcher) {
            super((Object)launcher, TaskLauncherAssert.class);
        }
    }
}

