/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.test;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppScaleRequest;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.test.AbstractIntegrationJUnit5Tests;
import org.springframework.cloud.deployer.spi.test.Timeout;
import org.springframework.core.io.Resource;

public abstract class AbstractAppDeployerIntegrationJUnit5Tests
extends AbstractIntegrationJUnit5Tests {
    private AppDeployerWrapper deployerWrapper;

    protected abstract AppDeployer provideAppDeployer();

    protected AppDeployer appDeployer() {
        return this.deployerWrapper;
    }

    @BeforeEach
    public void wrapDeployer() {
        this.deployerWrapper = new AppDeployerWrapper(this.provideAppDeployer());
    }

    @AfterEach
    public void cleanupLingeringApps() {
        for (String id : this.deployerWrapper.deployments) {
            try {
                this.log.warn("Test named {} left behind an app for deploymentId '{}', trying to cleanup", (Object)this.testName, (Object)id);
                this.deployerWrapper.wrapped.undeploy(id);
            }
            catch (Exception e) {
                this.log.warn("Exception caught while trying to cleanup '{}'. Moving on...", (Object)id);
            }
        }
    }

    @Test
    public void testUnknownDeployment() {
        String unknownId = this.randomName();
        AppStatus status = this.appDeployer().status(unknownId);
        Assertions.assertThat((String)status.getDeploymentId()).isEqualTo(unknownId);
        ((MapAssert)Assertions.assertThat((Map)status.getInstances()).as("The map was not empty: " + status.getInstances(), new Object[0])).isEmpty();
        Assertions.assertThat((Comparable)status.getState()).isEqualTo((Object)DeploymentState.unknown);
    }

    @Test
    public void testSimpleDeployment() {
        AppDefinition definition = new AppDefinition(this.randomName(), null);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.deployed));
        this.log.info("Deploying {} again...", (Object)request.getDefinition().getName());
        Assertions.assertThatThrownBy(() -> this.appDeployer().deploy(request)).isInstanceOf(IllegalStateException.class);
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.unknown));
        Assertions.assertThatThrownBy(() -> this.appDeployer().undeploy(deploymentId)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testRedeploy() {
        AppDefinition definition = new AppDefinition(this.randomName(), null);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.deployed));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.unknown));
        try {
            Thread.sleep(this.redeploymentPause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.log.info("Deploying {} again...", (Object)request.getDefinition().getName());
        String deploymentId2 = this.appDeployer().deploy(request);
        timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId2).getState()).isEqualTo((Object)DeploymentState.deployed));
        this.log.info("Undeploying {}...", (Object)deploymentId2);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId2);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId2).getState()).isEqualTo((Object)DeploymentState.unknown));
    }

    @Test
    public void testDeployingStateCalculationAndCancel() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("initDelay", "3600000");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, properties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.deploying));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.unknown));
    }

    @Test
    public void testFailedDeployment() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("killDelay", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, properties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.failed));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.unknown));
    }

    @Test
    public void testApplicationPropertiesPassing() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("parameterThatMayNeedEscaping", "&'\"|< \u00e9\\(");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        deploymentProperties.put("killDelay", "0");
        AppDeploymentRequest request = new AppDeploymentRequest(definition, this.testApplication(), deploymentProperties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.deployed));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.unknown));
        properties.put("parameterThatMayNeedEscaping", "notWhatIsExpected");
        definition = new AppDefinition(this.randomName(), properties);
        request = new AppDeploymentRequest(definition, this.testApplication(), deploymentProperties);
        this.log.info("Deploying {}, expecting it to fail...", (Object)request.getDefinition().getName());
        String deploymentId2 = this.appDeployer().deploy(request);
        timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId2).getState()).isEqualTo((Object)DeploymentState.failed));
        this.log.info("Undeploying {}...", (Object)deploymentId2);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId2);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId2).getState()).isEqualTo((Object)DeploymentState.unknown));
    }

    @Test
    public void testCommandLineArgumentsPassing() {
        HashMap properties = new HashMap();
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        HashMap deploymentProperties = new HashMap();
        List<String> cmdLineArgs = Arrays.asList("--commandLineArgValueThatMayNeedEscaping=&'\"|< \u00e9\\(");
        AppDeploymentRequest request = new AppDeploymentRequest(definition, this.testApplication(), deploymentProperties, cmdLineArgs);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.deployed));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.unknown));
        properties = new HashMap();
        definition = new AppDefinition(this.randomName(), properties);
        deploymentProperties = new HashMap();
        cmdLineArgs = Arrays.asList("--commandLineArgValueThatMayNeedEscaping=notWhatIsExpected");
        request = new AppDeploymentRequest(definition, this.testApplication(), deploymentProperties, cmdLineArgs);
        this.log.info("Deploying {}, expecting it to fail...", (Object)request.getDefinition().getName());
        String deploymentId2 = this.appDeployer().deploy(request);
        timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId2).getState()).isEqualTo((Object)DeploymentState.failed));
        this.log.info("Undeploying {}...", (Object)deploymentId2);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId2);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId2).getState()).isEqualTo((Object)DeploymentState.unknown));
    }

    @Test
    public void testMultipleInstancesDeploymentAndPartialState() {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("matchInstances", "1");
        appProperties.put("killDelay", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        deploymentProperties.put("spring.cloud.deployer.count", "3");
        deploymentProperties.put("spring.cloud.deployer.indexed", "true");
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, deploymentProperties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.partial));
        ArrayList<DeploymentState> individualStates = new ArrayList<DeploymentState>();
        for (AppInstanceStatus status : this.appDeployer().status(deploymentId).getInstances().values()) {
            individualStates.add(status.getState());
        }
        Assertions.assertThat(individualStates).containsExactlyInAnyOrder((Object[])new DeploymentState[]{DeploymentState.deployed, DeploymentState.deployed, DeploymentState.failed});
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.unknown));
    }

    @Test
    public void testEnvironmentInfo() {
        RuntimeEnvironmentInfo info = this.appDeployer().environmentInfo();
        Assertions.assertThat((String)info.getImplementationVersion()).isNotNull();
        Assertions.assertThat((String)info.getPlatformType()).isNotNull();
        Assertions.assertThat((String)info.getPlatformClientVersion()).isNotNull();
        Assertions.assertThat((String)info.getPlatformHostVersion()).isNotNull();
    }

    @Test
    @Disabled(value="Disabled pending the implementation of this feature.")
    public void testScale() {
        this.doTestScale(false);
    }

    @Test
    @Disabled(value="Disabled pending the implementation of this feature.")
    public void testScaleWithIndex() {
        this.doTestScale(true);
    }

    protected void doTestScale(Boolean indexed) {
        int DESIRED_COUNT = 3;
        Map<String, String> deploymentProperties = Collections.singletonMap("spring.cloud.deployer.indexed", indexed.toString());
        AppDefinition definition = new AppDefinition(this.randomName(), null);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, deploymentProperties);
        this.log.info("Deploying {} index={}...", (Object)request.getDefinition().getName(), (Object)indexed);
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.deployed));
        this.log.info("Scaling {} to {} instances...", (Object)request.getDefinition().getName(), (Object)3);
        this.appDeployer().scale(new AppScaleRequest(deploymentId, 3));
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.deployed));
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Map)this.appDeployer().status(deploymentId).getInstances()).hasSize(3));
        ArrayList<DeploymentState> individualStates = new ArrayList<DeploymentState>();
        for (AppInstanceStatus status : this.appDeployer().status(deploymentId).getInstances().values()) {
            individualStates.add(status.getState());
        }
        Assertions.assertThat(individualStates).allMatch(is -> is == DeploymentState.deployed);
        this.log.info("Scaling {} from {} to 1 instance...", (Object)request.getDefinition().getName(), (Object)3);
        this.appDeployer().scale(new AppScaleRequest(deploymentId, 1));
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.deployed));
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Map)this.appDeployer().status(deploymentId).getInstances()).hasSize(1));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Awaitility.await().pollInterval(Duration.ofMillis(timeout.pause)).atMost(Duration.ofMillis(timeout.maxAttempts * timeout.pause)).untilAsserted(() -> Assertions.assertThat((Comparable)this.appDeployer().status(deploymentId).getState()).isEqualTo((Object)DeploymentState.unknown));
    }

    protected static class AppDeployerWrapper
    implements AppDeployer {
        private final AppDeployer wrapped;
        private final Set<String> deployments = new LinkedHashSet<String>();

        public AppDeployerWrapper(AppDeployer wrapped) {
            this.wrapped = wrapped;
        }

        public String deploy(AppDeploymentRequest request) {
            String deploymentId = this.wrapped.deploy(request);
            this.deployments.add(deploymentId);
            return deploymentId;
        }

        public void undeploy(String id) {
            this.wrapped.undeploy(id);
            this.deployments.remove(id);
        }

        public AppStatus status(String id) {
            return this.wrapped.status(id);
        }

        public RuntimeEnvironmentInfo environmentInfo() {
            return this.wrapped.environmentInfo();
        }

        public String getLog(String id) {
            return this.wrapped.getLog(id);
        }

        public void scale(AppScaleRequest appScaleRequest) {
            this.wrapped.scale(appScaleRequest);
        }
    }
}

