/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.test;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.springframework.cloud.deployer.spi.app.AppDeployer;

public class AppCountMatcher
extends BaseMatcher<String> {
    private final Matcher<Integer> delegate;
    private final AppDeployer appDeployer;
    private Integer appInstanceCount;

    public AppCountMatcher(Matcher<Integer> delegate, AppDeployer appDeployer) {
        this.delegate = delegate;
        this.appDeployer = appDeployer;
    }

    public boolean matches(Object actual) {
        this.appInstanceCount = this.appDeployer.status((String)actual).getInstances().size();
        return this.delegate.matches((Object)this.appInstanceCount);
    }

    public void describeMismatch(Object item, Description mismatchDescription) {
        mismatchDescription.appendText("App instance count of ").appendValue(item).appendText(" ");
        this.delegate.describeMismatch((Object)this.appInstanceCount, mismatchDescription);
    }

    public void describeTo(Description description) {
        this.delegate.describeTo(description);
    }

    public static AppCountMatcher hasAppCount(Matcher<Integer> delegate, AppDeployer appDeployer) {
        return new AppCountMatcher(delegate, appDeployer);
    }
}

