/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.test;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.test.EventuallyMatcher;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public abstract class AbstractAppDeployerIntegrationTests {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    protected abstract AppDeployer appDeployer();

    @Test
    public void testUnknownDeployment() {
        String unknownId = this.randomName();
        AppStatus status = this.appDeployer().status(unknownId);
        Assert.assertThat((Object)status.getDeploymentId(), (Matcher)Matchers.is((Object)unknownId));
        Assert.assertThat((String)("The map was not empty: " + status.getInstances()), (Object)status.getInstances().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)status.getState(), (Matcher)Matchers.is((Object)DeploymentState.unknown));
    }

    @Test
    public void testSimpleDeployment() {
        AppDefinition definition = new AppDefinition(this.randomName(), null);
        Resource resource = this.integrationTestProcessor();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deployed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Deploying {} again...", (Object)request.getDefinition().getName());
        try {
            this.appDeployer().deploy(request);
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException ok) {
            // empty catch block
        }
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testRedeploy() {
        AppDefinition definition = new AppDefinition(this.randomName(), null);
        Resource resource = this.integrationTestProcessor();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deployed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
        try {
            Thread.sleep(this.redeploymentPause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.log.info("Deploying {} again...", (Object)request.getDefinition().getName());
        deploymentId = this.appDeployer().deploy(request);
        timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deployed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testDeployingStateCalculationAndCancel() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("initDelay", "3600000");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        Resource resource = this.integrationTestProcessor();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, properties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deploying))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testFailedDeployment() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("killDelay", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        Resource resource = this.integrationTestProcessor();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, properties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.failed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testParameterPassing() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("parameterThatMayNeedEscaping", "&'\"|< \u00e9\\(");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        AppDeploymentRequest request = new AppDeploymentRequest(definition, this.integrationTestProcessor());
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.appDeployer().deploy(request);
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deployed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    protected String randomName() {
        return UUID.randomUUID().toString();
    }

    protected Timeout deploymentTimeout() {
        return new Timeout(12, 5000);
    }

    protected Timeout undeploymentTimeout() {
        return new Timeout(20, 5000);
    }

    protected int redeploymentPause() {
        return 0;
    }

    protected Resource integrationTestProcessor() {
        Properties properties = new Properties();
        try {
            properties.load(new ClassPathResource("integration-test-app.properties").getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to determine which version of integration-test-app to use", e);
        }
        return new MavenResource.Builder().groupId("org.springframework.cloud").artifactId("spring-cloud-deployer-spi-test-app").classifier("exec").version(properties.getProperty("version")).extension("jar").build();
    }

    protected Matcher<String> hasStatusThat(final Matcher<AppStatus> statusMatcher) {
        return new BaseMatcher<String>(){
            private AppStatus status;

            public boolean matches(Object item) {
                this.status = AbstractAppDeployerIntegrationTests.this.appDeployer().status((String)item);
                return statusMatcher.matches((Object)this.status);
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
                mismatchDescription.appendText("status of ").appendValue(item).appendText(" ");
                statusMatcher.describeMismatch((Object)this.status, mismatchDescription);
            }

            public void describeTo(Description description) {
                statusMatcher.describeTo(description);
            }
        };
    }

    protected static class Timeout {
        public final int maxAttempts;
        public final int pause;

        public Timeout(int maxAttempts, int pause) {
            this.maxAttempts = maxAttempts;
            this.pause = pause;
        }
    }
}

