/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.scheduler.test.app;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.scheduler.test.app.SchedulerIntegrationTestProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@EnableConfigurationProperties(value={SchedulerIntegrationTestProperties.class})
@Configuration
public class SchedulerIntegrationTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SchedulerIntegrationTestProperties properties;

    @PostConstruct
    public void init() throws InterruptedException {
        String parameterThatMayNeedEscaping = this.properties.getParameterThatMayNeedEscaping();
        if (parameterThatMayNeedEscaping != null && !"&'\"|< \u00e9\\(".equals(parameterThatMayNeedEscaping)) {
            throw new IllegalArgumentException(String.format("Expected 'parameterThatMayNeedEscaping' value to be equal to '%s', but was '%s'", "&'\"|< \u00e9\\(", parameterThatMayNeedEscaping));
        }
        String commandLineArgValueThatMayNeedEscaping = this.properties.getCommandLineArgValueThatMayNeedEscaping();
        if (commandLineArgValueThatMayNeedEscaping != null && !"&'\"|< \u00e9\\(".equals(commandLineArgValueThatMayNeedEscaping)) {
            throw new IllegalArgumentException(String.format("Expected 'commandLineArgValueThatMayNeedEscaping' value to be equal to '%s', but was '%s'", "&'\"|< \u00e9\\(", commandLineArgValueThatMayNeedEscaping));
        }
        Assert.notNull((Object)this.properties.getInstanceIndex(), (String)"instanceIndex should have been set by deployer or runtime");
        if (this.properties.getMatchInstances().isEmpty() || this.properties.getMatchInstances().contains(this.properties.getInstanceIndex())) {
            this.log.info("Waiting for %dms before allowing further initialization and actuator startup...", (Object)this.properties.getInitDelay());
            Thread.sleep(this.properties.getInitDelay());
            this.log.info("... done");
            if (this.properties.getKillDelay() >= 0) {
                this.log.info("Will kill this process in %dms%n", (Object)this.properties.getKillDelay());
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(SchedulerIntegrationTest.this.properties.getKillDelay());
                            System.exit(SchedulerIntegrationTest.this.properties.getExitCode());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }.start();
            }
        }
    }
}

