/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationDigest;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class MavenArtifactResolver {
    private static final Log log = LogFactory.getLog(MavenArtifactResolver.class);
    private static final String DEFAULT_CONTENT_TYPE = "default";
    private final RepositorySystem repositorySystem;
    private final MavenProperties properties;
    private final List<RemoteRepository> remoteRepositories = new LinkedList<RemoteRepository>();
    private final Authentication authentication;

    public MavenArtifactResolver(MavenProperties properties) {
        Assert.notNull((Object)properties, (String)"MavenProperties must not be null");
        Assert.notNull((Object)properties.getLocalRepository(), (String)"Local repository path cannot be null");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Local repository: " + properties.getLocalRepository()));
            log.debug((Object)("Remote repositories: " + StringUtils.collectionToCommaDelimitedString(properties.getRemoteRepositories().keySet())));
        }
        this.properties = properties;
        if (this.isProxyEnabled() && this.proxyHasCredentials()) {
            String username = this.properties.getProxy().getAuth().getUsername();
            String password = this.properties.getProxy().getAuth().getPassword();
            this.authentication = this.newAuthentication(username, password);
        } else {
            this.authentication = null;
        }
        File localRepository = new File(this.properties.getLocalRepository());
        if (!localRepository.exists()) {
            Assert.isTrue((boolean)localRepository.mkdirs(), (String)("Unable to create directory for local repository: " + localRepository));
        }
        for (Map.Entry<String, MavenProperties.RemoteRepository> entry : this.properties.getRemoteRepositories().entrySet()) {
            MavenProperties.RemoteRepository remoteRepository = entry.getValue();
            RemoteRepository.Builder remoteRepositoryBuilder = new RemoteRepository.Builder(entry.getKey(), DEFAULT_CONTENT_TYPE, remoteRepository.getUrl());
            if (this.isProxyEnabled()) {
                MavenProperties.Proxy proxyProperties = this.properties.getProxy();
                if (this.authentication != null) {
                    remoteRepositoryBuilder.setProxy(new Proxy(proxyProperties.getProtocol(), proxyProperties.getHost(), proxyProperties.getPort(), this.authentication));
                } else {
                    remoteRepositoryBuilder.setProxy(new Proxy(proxyProperties.getProtocol(), proxyProperties.getHost(), proxyProperties.getPort()));
                }
            }
            if (this.remoteRepositoryHasCredentials(remoteRepository)) {
                String username = remoteRepository.getAuth().getUsername();
                String password = remoteRepository.getAuth().getPassword();
                remoteRepositoryBuilder.setAuthentication(this.newAuthentication(username, password));
            }
            this.remoteRepositories.add(remoteRepositoryBuilder.build());
        }
        this.repositorySystem = this.newRepositorySystem();
    }

    private boolean isProxyEnabled() {
        return this.properties.getProxy() != null && this.properties.getProxy().getHost() != null && this.properties.getProxy().getPort() > 0;
    }

    private boolean proxyHasCredentials() {
        return this.properties.getProxy() != null && this.properties.getProxy().getAuth() != null && this.properties.getProxy().getAuth().getUsername() != null && this.properties.getProxy().getAuth().getPassword() != null;
    }

    private boolean remoteRepositoryHasCredentials(MavenProperties.RemoteRepository remoteRepository) {
        return remoteRepository != null && remoteRepository.getAuth() != null && remoteRepository.getAuth().getUsername() != null && remoteRepository.getAuth().getPassword() != null;
    }

    private Authentication newAuthentication(final String username, final String password) {
        return new Authentication(){

            public void fill(AuthenticationContext context, String key, Map<String, String> data) {
                context.put("username", (Object)username);
                context.put("password", (Object)password);
            }

            public void digest(AuthenticationDigest digest) {
                digest.update(new String[]{"username", username, "password", password});
            }
        };
    }

    private DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepoPath) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localRepoPath);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setOffline(this.properties.isOffline());
        if (this.properties.getConnectTimeout() != null) {
            session.setConfigProperty("aether.connector.connectTimeout", (Object)this.properties.getConnectTimeout());
        }
        if (this.properties.getRequestTimeout() != null) {
            session.setConfigProperty("aether.connector.requestTimeout", (Object)this.properties.getRequestTimeout());
        }
        if (this.isProxyEnabled()) {
            DefaultProxySelector proxySelector = new DefaultProxySelector();
            Proxy proxy = new Proxy(this.properties.getProxy().getProtocol(), this.properties.getProxy().getHost(), this.properties.getProxy().getPort(), this.authentication);
            proxySelector.add(proxy, this.properties.getProxy().getNonProxyHosts());
            session.setProxySelector((ProxySelector)proxySelector);
        }
        return session;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                throw new RuntimeException(exception);
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    Resource resolve(MavenResource resource) {
        ArtifactResult resolvedArtifact;
        Assert.notNull((Object)((Object)resource), (String)"MavenResource must not be null");
        this.validateCoordinates(resource);
        DefaultRepositorySystemSession session = this.newRepositorySystemSession(this.repositorySystem, this.properties.getLocalRepository());
        try {
            ArrayList<ArtifactRequest> artifactRequests = new ArrayList<ArtifactRequest>(2);
            if (this.properties.isResolvePom()) {
                artifactRequests.add(new ArtifactRequest(this.toPomArtifact(resource), this.remoteRepositories, "runtime"));
            }
            artifactRequests.add(new ArtifactRequest(this.toJarArtifact(resource), this.remoteRepositories, "runtime"));
            List results = this.repositorySystem.resolveArtifacts((RepositorySystemSession)session, artifactRequests);
            resolvedArtifact = (ArtifactResult)results.get(results.size() - 1);
        }
        catch (ArtifactResolutionException e) {
            StringBuilder errorMessage = new StringBuilder("failed to resolve MavenResource: %s. Configured remote ");
            if (this.properties.getRemoteRepositories().size() > 1) {
                errorMessage.append("repositories: ");
            } else {
                errorMessage.append("repository: ");
            }
            errorMessage.append(StringUtils.collectionToCommaDelimitedString(this.properties.getRemoteRepositories().keySet()));
            throw new IllegalStateException(String.format(errorMessage.toString(), resource.toString()), e);
        }
        return this.toResource(resolvedArtifact);
    }

    private void validateCoordinates(MavenResource resource) {
        Assert.hasText((String)resource.getGroupId(), (String)"groupId must not be blank.");
        Assert.hasText((String)resource.getArtifactId(), (String)"artifactId must not be blank.");
        Assert.hasText((String)resource.getExtension(), (String)"extension must not be blank.");
        Assert.hasText((String)resource.getVersion(), (String)"version must not be blank.");
    }

    public FileSystemResource toResource(ArtifactResult resolvedArtifact) {
        return new FileSystemResource(resolvedArtifact.getArtifact().getFile());
    }

    private Artifact toJarArtifact(MavenResource resource) {
        return this.toArtifact(resource, resource.getExtension());
    }

    private Artifact toPomArtifact(MavenResource resource) {
        return this.toArtifact(resource, "pom");
    }

    private Artifact toArtifact(MavenResource resource, String extension) {
        return new DefaultArtifact(resource.getGroupId(), resource.getArtifactId(), resource.getClassifier() != null ? resource.getClassifier() : "", extension, resource.getVersion());
    }
}

