/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppAdmin;
import org.springframework.cloud.deployer.spi.local.LocalDeployerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="spring.cloud.deployer.local")
public class LocalDeployerProperties {
    public static final String PREFIX = "spring.cloud.deployer.local";
    public static final String INHERIT_LOGGING = "spring.cloud.deployer.local.inherit-logging";
    public static final String DEBUG_PORT = "spring.cloud.deployer.local.debug-port";
    public static final String DEBUG_ADDRESS = "spring.cloud.deployer.local.debug-address";
    public static final String DEBUG_SUSPEND = "spring.cloud.deployer.local.debug-suspend";
    private static final Logger logger = LoggerFactory.getLogger(LocalDeployerProperties.class);
    private static final String JAVA_COMMAND = LocalDeployerUtils.isWindows() ? "java.exe" : "java";
    private static final String[] ENV_VARS_TO_INHERIT_DEFAULTS_WIN = new String[]{"TMP", "TEMP", "PATH", "Path", "SPRING_APPLICATION_JSON"};
    private static final String[] ENV_VARS_TO_INHERIT_DEFAULTS_OTHER = new String[]{"TMP", "LANG", "LANGUAGE", "LC_.*", "PATH", "SPRING_APPLICATION_JSON"};
    private Path workingDirectoriesRoot = new File(System.getProperty("java.io.tmpdir")).toPath();
    private boolean deleteFilesOnExit = true;
    private String[] envVarsToInherit = LocalDeployerUtils.isWindows() ? ENV_VARS_TO_INHERIT_DEFAULTS_WIN : ENV_VARS_TO_INHERIT_DEFAULTS_OTHER;
    private String javaCmd = JAVA_COMMAND;
    @Min(value=-1L)
    private @Min(value=-1L) int shutdownTimeout = 30;
    private String javaOpts;
    private boolean useSpringApplicationJson = true;
    private final PortRange portRange = new PortRange();
    @Min(value=1L)
    private @Min(value=1L) int maximumConcurrentTasks = 20;
    private Integer debugPort;
    private String debugAddress;
    private DebugSuspendType debugSuspend = DebugSuspendType.y;
    private boolean inheritLogging;
    private final Docker docker = new Docker();
    private String hostname;
    private Map<String, String> javaHomePath = new HashMap<String, String>();
    private AppAdmin appAdmin = new AppAdmin();
    private HttpProbe startupProbe = new HttpProbe();
    private HttpProbe healthProbe = new HttpProbe();

    public LocalDeployerProperties() {
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            this.javaHomePath.put("2", javaHome);
            this.javaHomePath.put("3", javaHome);
        }
    }

    public LocalDeployerProperties(LocalDeployerProperties from) {
        this.debugPort = from.getDebugPort();
        this.debugAddress = from.getDebugAddress();
        this.debugSuspend = from.getDebugSuspend();
        this.deleteFilesOnExit = from.isDeleteFilesOnExit();
        this.docker.network = from.getDocker().getNetwork();
        this.docker.deleteContainerOnExit = from.getDocker().isDeleteContainerOnExit();
        this.docker.portRange = from.getDocker().getPortRange();
        this.envVarsToInherit = new String[from.getEnvVarsToInherit().length];
        System.arraycopy(from.getEnvVarsToInherit(), 0, this.envVarsToInherit, 0, from.getEnvVarsToInherit().length);
        this.inheritLogging = from.isInheritLogging();
        this.javaCmd = from.getJavaCmd();
        this.javaOpts = from.getJavaOpts();
        this.maximumConcurrentTasks = from.getMaximumConcurrentTasks();
        this.portRange.high = from.getPortRange().getHigh();
        this.portRange.low = from.getPortRange().getLow();
        this.shutdownTimeout = from.getShutdownTimeout();
        this.useSpringApplicationJson = from.isUseSpringApplicationJson();
        this.workingDirectoriesRoot = Paths.get(from.getWorkingDirectoriesRoot().toUri());
        this.hostname = from.getHostname();
        this.appAdmin = from.getAppAdmin();
        this.javaHomePath = from.getJavaHomePath().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.startupProbe = from.getStartupProbe();
        this.healthProbe = from.getHealthProbe();
    }

    public Docker getDocker() {
        return this.docker;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Integer getDebugPort() {
        return this.debugPort;
    }

    public DebugSuspendType getDebugSuspend() {
        return this.debugSuspend;
    }

    public void setDebugSuspend(DebugSuspendType debugSuspend) {
        this.debugSuspend = debugSuspend;
    }

    public void setDebugPort(Integer debugPort) {
        logger.warn("The debugPort is deprecated! It supports only pre Java 9 environments. Please use the debugAddress property instead!");
        this.debugPort = debugPort;
    }

    public String getDebugAddress() {
        return this.debugAddress;
    }

    public void setDebugAddress(String debugAddress) {
        this.debugAddress = debugAddress;
    }

    public boolean isInheritLogging() {
        return this.inheritLogging;
    }

    public void setInheritLogging(boolean inheritLogging) {
        this.inheritLogging = inheritLogging;
    }

    public String getJavaCommand(String bootVersion) {
        if (!StringUtils.hasText((String)this.javaCmd) || this.javaCmd.equals(JAVA_COMMAND)) {
            return this.deduceJavaCommand(bootVersion);
        }
        return this.javaCmd;
    }

    public Map<String, String> getJavaHomePath() {
        return this.javaHomePath;
    }

    public void setJavaHomePath(Map<String, String> javaHomePath) {
        this.javaHomePath = javaHomePath;
    }

    public String getJavaCmd() {
        return this.javaCmd;
    }

    public void setJavaCmd(String javaCmd) {
        this.javaCmd = javaCmd;
    }

    public Path getWorkingDirectoriesRoot() {
        return this.workingDirectoriesRoot;
    }

    public void setWorkingDirectoriesRoot(String workingDirectoriesRoot) {
        this.workingDirectoriesRoot = Paths.get(workingDirectoriesRoot, new String[0]);
    }

    public void setWorkingDirectoriesRoot(Path workingDirectoriesRoot) {
        this.workingDirectoriesRoot = workingDirectoriesRoot;
    }

    public boolean isDeleteFilesOnExit() {
        return this.deleteFilesOnExit;
    }

    public void setDeleteFilesOnExit(boolean deleteFilesOnExit) {
        this.deleteFilesOnExit = deleteFilesOnExit;
    }

    public String[] getEnvVarsToInherit() {
        return this.envVarsToInherit;
    }

    public void setEnvVarsToInherit(String[] envVarsToInherit) {
        this.envVarsToInherit = envVarsToInherit;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public LocalDeployerProperties setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public void setJavaOpts(String javaOpts) {
        this.javaOpts = javaOpts;
    }

    public boolean isUseSpringApplicationJson() {
        return this.useSpringApplicationJson;
    }

    public void setUseSpringApplicationJson(boolean useSpringApplicationJson) {
        this.useSpringApplicationJson = useSpringApplicationJson;
    }

    public PortRange getPortRange() {
        return this.portRange;
    }

    public int getMaximumConcurrentTasks() {
        return this.maximumConcurrentTasks;
    }

    public void setMaximumConcurrentTasks(int maximumConcurrentTasks) {
        this.maximumConcurrentTasks = maximumConcurrentTasks;
    }

    public HttpProbe getStartupProbe() {
        return this.startupProbe;
    }

    public void setStartupProbe(HttpProbe startupProbe) {
        this.startupProbe = startupProbe;
    }

    public HttpProbe getHealthProbe() {
        return this.healthProbe;
    }

    public void setHealthProbe(HttpProbe healthProbe) {
        this.healthProbe = healthProbe;
    }

    public AppAdmin getAppAdmin() {
        return this.appAdmin;
    }

    public void setAppAdmin(AppAdmin appAdmin) {
        this.appAdmin = appAdmin;
    }

    private String deduceJavaCommand(String bootVersion) {
        String javaExecutablePath = JAVA_COMMAND;
        String javaHome = this.getJavaHome(bootVersion);
        if (StringUtils.hasText((String)javaHome)) {
            File javaExecutable = new File(javaHome, "bin" + File.separator + javaExecutablePath);
            Assert.isTrue((boolean)javaExecutable.exists(), () -> "Java executable'" + javaExecutable + "'discovered via 'java.home' system property '" + this.javaHomePath + "' does not exist.");
            Assert.isTrue((boolean)javaExecutable.canExecute(), () -> "Java executable'" + javaExecutable + "'discovered via 'java.home' system property '" + this.javaHomePath + "' is not executable.");
            javaExecutablePath = javaExecutable.getAbsolutePath();
        } else {
            logger.warn("System property 'java.home' and 'spring.cloud.deployer.local.{}.javaHomePath' is not set. Defaulting to the java executable path as " + JAVA_COMMAND + " assuming it's in PATH.", (Object)bootVersion);
        }
        return javaExecutablePath;
    }

    private String getJavaHome(String bootVersion) {
        String path = this.javaHomePath.get(bootVersion);
        return path == null ? System.getProperty("java.home") : path;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("workingDirectoriesRoot", (Object)this.workingDirectoriesRoot).append("javaOpts", (Object)this.javaOpts).append("envVarsToInherit", (Object)this.envVarsToInherit).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDeployerProperties that = (LocalDeployerProperties)o;
        if (this.deleteFilesOnExit != that.deleteFilesOnExit) {
            return false;
        }
        if (this.shutdownTimeout != that.shutdownTimeout) {
            return false;
        }
        if (this.useSpringApplicationJson != that.useSpringApplicationJson) {
            return false;
        }
        if (this.maximumConcurrentTasks != that.maximumConcurrentTasks) {
            return false;
        }
        if (this.inheritLogging != that.inheritLogging) {
            return false;
        }
        if (!Objects.equals(this.workingDirectoriesRoot, that.workingDirectoriesRoot)) {
            return false;
        }
        if (!Arrays.equals(this.envVarsToInherit, that.envVarsToInherit)) {
            return false;
        }
        if (!Objects.equals(this.javaCmd, that.javaCmd)) {
            return false;
        }
        if (!Objects.equals(this.javaOpts, that.javaOpts)) {
            return false;
        }
        if (!this.portRange.equals(that.portRange)) {
            return false;
        }
        if (!Objects.equals(this.debugPort, that.debugPort)) {
            return false;
        }
        if (!Objects.equals(this.debugAddress, that.debugAddress)) {
            return false;
        }
        if (this.debugSuspend != that.debugSuspend) {
            return false;
        }
        if (!this.docker.equals(that.docker)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.javaHomePath, that.javaHomePath)) {
            return false;
        }
        if (!Objects.equals(this.appAdmin, that.appAdmin)) {
            return false;
        }
        if (!Objects.equals(this.startupProbe, that.startupProbe)) {
            return false;
        }
        return Objects.equals(this.healthProbe, that.healthProbe);
    }

    public int hashCode() {
        int result = this.workingDirectoriesRoot != null ? this.workingDirectoriesRoot.hashCode() : 0;
        result = 31 * result + (this.deleteFilesOnExit ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.envVarsToInherit);
        result = 31 * result + (this.javaCmd != null ? this.javaCmd.hashCode() : 0);
        result = 31 * result + this.shutdownTimeout;
        result = 31 * result + (this.javaOpts != null ? this.javaOpts.hashCode() : 0);
        result = 31 * result + (this.useSpringApplicationJson ? 1 : 0);
        result = 31 * result + this.portRange.hashCode();
        result = 31 * result + this.maximumConcurrentTasks;
        result = 31 * result + (this.debugPort != null ? this.debugPort.hashCode() : 0);
        result = 31 * result + (this.debugAddress != null ? this.debugAddress.hashCode() : 0);
        result = 31 * result + (this.debugSuspend != null ? this.debugSuspend.hashCode() : 0);
        result = 31 * result + (this.inheritLogging ? 1 : 0);
        result = 31 * result + this.docker.hashCode();
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.javaHomePath != null ? this.javaHomePath.hashCode() : 0);
        result = 31 * result + (this.appAdmin != null ? this.appAdmin.hashCode() : 0);
        result = 31 * result + (this.startupProbe != null ? this.startupProbe.hashCode() : 0);
        result = 31 * result + (this.healthProbe != null ? this.healthProbe.hashCode() : 0);
        return result;
    }

    public static class HttpProbe {
        private String path;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class Docker {
        private String network = "bridge";
        private boolean deleteContainerOnExit = true;
        private PortRange portRange = new PortRange();
        private String portMappings;
        private String volumeMounts;

        public PortRange getPortRange() {
            return this.portRange;
        }

        public String getNetwork() {
            return this.network;
        }

        public void setNetwork(String network) {
            this.network = network;
        }

        public boolean isDeleteContainerOnExit() {
            return this.deleteContainerOnExit;
        }

        public void setDeleteContainerOnExit(boolean deleteContainerOnExit) {
            this.deleteContainerOnExit = deleteContainerOnExit;
        }

        public String getPortMappings() {
            return this.portMappings;
        }

        public void setPortMappings(String portMappings) {
            this.portMappings = portMappings;
        }

        public String getVolumeMounts() {
            return this.volumeMounts;
        }

        public void setVolumeMounts(String volumeMounts) {
            this.volumeMounts = volumeMounts;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Docker other = (Docker)obj;
            if (this.network == null) {
                return other.network == null;
            }
            return this.network.equals(other.network);
        }
    }

    public static class PortRange {
        private int low = 20000;
        private int high = 61000;

        public int getLow() {
            return this.low;
        }

        public void setLow(int low) {
            this.low = low;
        }

        public int getHigh() {
            return this.high;
        }

        public void setHigh(int high) {
            this.high = high;
        }

        public String toString() {
            return "{ low=" + this.low + ", high=" + this.high + '}';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.high;
            result = 31 * result + this.low;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortRange other = (PortRange)obj;
            if (this.high != other.high) {
                return false;
            }
            return this.low == other.low;
        }
    }

    public static enum DebugSuspendType {
        y,
        n;

    }
}

