/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.AbstractLocalDeployerSupport;
import org.springframework.cloud.deployer.spi.local.CommandBuilder;
import org.springframework.cloud.deployer.spi.local.DebugAddress;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class JavaCommandBuilder
implements CommandBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LocalDeployerProperties properties;

    public JavaCommandBuilder(LocalDeployerProperties properties) {
        this.properties = properties;
    }

    @Override
    public int getPortSuggestion(LocalDeployerProperties localDeployerProperties) {
        return ThreadLocalRandom.current().nextInt(localDeployerProperties.getPortRange().getLow(), localDeployerProperties.getPortRange().getHigh());
    }

    @Override
    public URL getBaseUrl(String deploymentId, int index, int port) {
        try {
            return new URL("http", Inet4Address.getLocalHost().getHostAddress(), port, "");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ProcessBuilder buildExecutionCommand(AppDeploymentRequest request, Map<String, String> appInstanceEnv, String deployerId, Optional<Integer> appInstanceNumber, LocalDeployerProperties localDeployerProperties, Optional<DebugAddress> debugAddressOption) {
        ArrayList<String> commands = new ArrayList<String>();
        Map deploymentProperties = request.getDeploymentProperties();
        commands.add(this.bindDeploymentProperties(deploymentProperties).getJavaCmd());
        debugAddressOption.ifPresent(debugAddress -> commands.add(this.getJdwpOptions(debugAddress.getSuspend(), debugAddress.getAddress())));
        this.addJavaOptions(commands, deploymentProperties, this.properties);
        this.addJavaExecutionOptions(commands, request);
        commands.addAll(request.getCommandlineArguments());
        this.logger.debug("Java Command = " + commands);
        ProcessBuilder builder = new ProcessBuilder(AbstractLocalDeployerSupport.windowsSupport(commands.toArray(new String[0])));
        this.retainEnvVars(builder.environment(), localDeployerProperties);
        builder.environment().putAll(appInstanceEnv);
        return builder;
    }

    protected void retainEnvVars(Map<String, String> vars, LocalDeployerProperties localDeployerProperties) {
        ArrayList<String> patterns = new ArrayList<String>(Arrays.asList(localDeployerProperties.getEnvVarsToInherit()));
        Iterator<Map.Entry<String, String>> iterator = vars.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String var = entry.getKey();
            boolean retain = false;
            for (String pattern : patterns) {
                if (!Pattern.matches(pattern, var)) continue;
                retain = true;
                break;
            }
            if (retain) continue;
            iterator.remove();
        }
    }

    protected void addJavaOptions(List<String> commands, Map<String, String> deploymentProperties, LocalDeployerProperties localDeployerProperties) {
        String javaOptsString;
        String memory = null;
        if (deploymentProperties.containsKey("spring.cloud.deployer.memory")) {
            memory = "-Xmx" + ByteSizeUtils.parseToMebibytes((String)deploymentProperties.get("spring.cloud.deployer.memory")) + "m";
        }
        if ((javaOptsString = this.bindDeploymentProperties(deploymentProperties).getJavaOpts()) == null && memory != null) {
            commands.add(memory);
        }
        if (javaOptsString != null) {
            String[] javaOpts = StringUtils.tokenizeToStringArray((String)javaOptsString, (String)" ");
            boolean noJavaMemoryOption = Stream.of(javaOpts).noneMatch(s -> s.startsWith("-Xmx"));
            if (noJavaMemoryOption && memory != null) {
                commands.add(memory);
            }
            commands.addAll(Arrays.asList(javaOpts));
        } else if (localDeployerProperties.getJavaOpts() != null) {
            String[] javaOpts = StringUtils.tokenizeToStringArray((String)localDeployerProperties.getJavaOpts(), (String)" ");
            commands.addAll(Arrays.asList(javaOpts));
        }
    }

    protected void addJavaExecutionOptions(List<String> commands, AppDeploymentRequest request) {
        commands.add("-jar");
        Resource resource = request.getResource();
        try {
            commands.add(resource.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected LocalDeployerProperties bindDeploymentProperties(Map<String, String> runtimeDeploymentProperties) {
        LocalDeployerProperties copyOfDefaultProperties = new LocalDeployerProperties(this.properties);
        return (LocalDeployerProperties)new Binder(new ConfigurationPropertySource[]{new MapConfigurationPropertySource(runtimeDeploymentProperties)}).bind("spring.cloud.deployer.local", Bindable.ofInstance((Object)copyOfDefaultProperties)).orElse((Object)copyOfDefaultProperties);
    }
}

