/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.local.CommandBuilder;
import org.springframework.cloud.deployer.spi.local.DebugAddress;
import org.springframework.cloud.deployer.spi.local.DockerCommandBuilder;
import org.springframework.cloud.deployer.spi.local.JavaCommandBuilder;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.cloud.deployer.spi.local.LocalDeployerUtils;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.SocketUtils;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractLocalDeployerSupport {
    protected static Set<Integer> usedPorts = Collections.newSetFromMap(new LinkedHashMap<Integer, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Boolean> eldest) {
            return this.size() > 1000;
        }
    });
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SPRING_APPLICATION_JSON = "SPRING_APPLICATION_JSON";
    public static final int DEFAULT_SERVER_PORT = 8080;
    private static final String USE_SPRING_APPLICATION_JSON_KEY = "spring.cloud.deployer.local.use-spring-application-json";
    static final String SERVER_PORT_KEY = "server.port";
    static final String SERVER_PORT_KEY_COMMAND_LINE_ARG = "--server.port=";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final LocalDeployerProperties localDeployerProperties;
    private final RestTemplate restTemplate;
    private final JavaCommandBuilder javaCommandBuilder;
    private final DockerCommandBuilder dockerCommandBuilder;

    public AbstractLocalDeployerSupport(LocalDeployerProperties localDeployerProperties) {
        Assert.notNull((Object)localDeployerProperties, (String)"LocalDeployerProperties must not be null");
        this.localDeployerProperties = localDeployerProperties;
        this.javaCommandBuilder = new JavaCommandBuilder(localDeployerProperties);
        this.dockerCommandBuilder = new DockerCommandBuilder(localDeployerProperties.getDocker().getNetwork());
        this.restTemplate = this.buildRestTemplate(localDeployerProperties);
    }

    protected RestTemplate buildRestTemplate(LocalDeployerProperties properties) {
        if (properties != null && properties.getShutdownTimeout() > -1) {
            SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
            clientHttpRequestFactory.setConnectTimeout(properties.getShutdownTimeout() * 1000);
            clientHttpRequestFactory.setReadTimeout(properties.getShutdownTimeout() * 1000);
            return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        }
        return new RestTemplate();
    }

    protected RuntimeEnvironmentInfo createRuntimeEnvironmentInfo(Class<?> spiClass, Class<?> implementationClass) {
        return new RuntimeEnvironmentInfo.Builder().spiClass(spiClass).implementationName(implementationClass.getSimpleName()).implementationVersion(RuntimeVersionUtils.getVersion(implementationClass)).platformType("Local").platformApiVersion(System.getProperty("os.name") + " " + System.getProperty("os.version")).platformClientVersion(System.getProperty("os.version")).platformHostVersion(System.getProperty("os.version")).build();
    }

    protected final LocalDeployerProperties getLocalDeployerProperties() {
        return this.localDeployerProperties;
    }

    protected ProcessBuilder buildProcessBuilder(AppDeploymentRequest request, Map<String, String> appInstanceEnv, Optional<Integer> appInstanceNumber, String deploymentId) {
        Assert.notNull((Object)request, (String)"AppDeploymentRequest must be set");
        Map<String, String> appPropertiesToUse = this.formatApplicationProperties(request, appInstanceEnv);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Preparing to run an application from {}. This may take some time if the artifact must be downloaded from a remote host.", (Object)request.getResource());
        }
        LocalDeployerProperties localDeployerProperties = this.bindDeploymentProperties(request.getDeploymentProperties());
        Optional<DebugAddress> debugAddressOption = DebugAddress.from(localDeployerProperties, appInstanceNumber.orElse(0));
        ProcessBuilder builder = this.getCommandBuilder(request).buildExecutionCommand(request, appPropertiesToUse, deploymentId, appInstanceNumber, localDeployerProperties, debugAddressOption);
        this.logger.info(String.format("Command to be executed: %s", String.join((CharSequence)" ", builder.command())));
        this.logger.debug(String.format("Environment Variables to be used : %s", builder.environment().entrySet().stream().map(entry -> (String)entry.getKey() + " : " + (String)entry.getValue()).collect(Collectors.joining(", "))));
        return builder;
    }

    protected CommandBuilder getCommandBuilder(AppDeploymentRequest request) {
        return request.getResource() instanceof DockerResource ? this.dockerCommandBuilder : this.javaCommandBuilder;
    }

    public static String[] windowsSupport(String[] commands) {
        if (LocalDeployerUtils.isWindows()) {
            for (int i = 0; i < commands.length; ++i) {
                commands[i] = commands[i].replace("\"", "\\\"");
            }
        }
        return commands;
    }

    protected LocalDeployerProperties bindDeploymentProperties(Map<String, String> runtimeDeploymentProperties) {
        LocalDeployerProperties copyOfDefaultProperties = new LocalDeployerProperties(this.localDeployerProperties);
        return (LocalDeployerProperties)new Binder(new ConfigurationPropertySource[]{new MapConfigurationPropertySource(runtimeDeploymentProperties)}).bind("spring.cloud.deployer.local", Bindable.ofInstance((Object)copyOfDefaultProperties)).orElse((Object)copyOfDefaultProperties);
    }

    protected Map<String, String> formatApplicationProperties(AppDeploymentRequest request, Map<String, String> appInstanceEnvToUse) {
        HashMap<String, String> applicationPropertiesToUse = new HashMap<String, String>(appInstanceEnvToUse);
        if (this.useSpringApplicationJson(request)) {
            try {
                if (applicationPropertiesToUse.containsKey(SPRING_APPLICATION_JSON)) {
                    applicationPropertiesToUse.putAll((Map)OBJECT_MAPPER.readValue((String)applicationPropertiesToUse.get(SPRING_APPLICATION_JSON), (TypeReference)new TypeReference<HashMap<String, String>>(){}));
                    applicationPropertiesToUse.remove(SPRING_APPLICATION_JSON);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read existing SPRING_APPLICATION_JSON to merge properties", e);
            }
            try {
                String saj = OBJECT_MAPPER.writeValueAsString(applicationPropertiesToUse);
                applicationPropertiesToUse = new HashMap(1);
                applicationPropertiesToUse.put(SPRING_APPLICATION_JSON, saj);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Unable to create SPRING_APPLICATION_JSON from application properties", e);
            }
        }
        return applicationPropertiesToUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownAndWait(Instance instance) {
        try {
            int timeout = this.getLocalDeployerProperties().getShutdownTimeout();
            if (timeout > 0) {
                this.logger.debug("About to call shutdown endpoint for the instance {}", (Object)instance);
                ResponseEntity response = this.restTemplate.postForEntity(instance.getBaseUrl() + "/shutdown", null, String.class, new Object[0]);
                this.logger.debug("Response for shutdown endpoint completed for the instance {} with response {}", (Object)instance, (Object)response);
                if (response.getStatusCode().is2xxSuccessful()) {
                    long timeoutTimestamp = System.currentTimeMillis() + (long)(timeout * 1000);
                    while (this.isAlive(instance.getProcess()) && System.currentTimeMillis() < timeoutTimestamp) {
                        Thread.sleep(1000L);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            if (this.isAlive(instance.getProcess())) {
                this.logger.debug("About to call destroy the process for the instance {}", (Object)instance);
                instance.getProcess().destroy();
                this.logger.debug("Call completed to destroy the process for the instance {}", (Object)instance);
            }
        }
    }

    protected boolean isAlive(Process process) {
        try {
            this.logger.debug("About to call exitValue of the process {}", (Object)process);
            process.exitValue();
            this.logger.debug("Call to exitValue of the process {} complete, return false", (Object)process);
            return false;
        }
        catch (IllegalThreadStateException e) {
            this.logger.debug("Call to exitValue of the process {} threw exception, return true", (Object)process);
            return true;
        }
    }

    protected boolean useSpringApplicationJson(AppDeploymentRequest request) {
        return request.getDefinition().getProperties().containsKey(USE_SPRING_APPLICATION_JSON_KEY) || this.localDeployerProperties.isUseSpringApplicationJson();
    }

    protected int calcServerPort(AppDeploymentRequest request, boolean useDynamicPort, Map<String, String> appInstanceEnvVars) {
        int port = 8080;
        Integer commandLineArgPort = this.isServerPortKeyPresentOnArgs(request);
        if (useDynamicPort) {
            port = this.getRandomPort(request);
            appInstanceEnvVars.put(SERVER_PORT_KEY, String.valueOf(port));
        } else if (commandLineArgPort != null) {
            port = commandLineArgPort;
        } else if (request.getDefinition().getProperties().containsKey(SERVER_PORT_KEY)) {
            port = Integer.parseInt((String)request.getDefinition().getProperties().get(SERVER_PORT_KEY));
        }
        return port;
    }

    protected boolean shouldInheritLogging(AppDeploymentRequest request) {
        LocalDeployerProperties bindDeployerProperties = this.bindDeploymentProperties(request.getDeploymentProperties());
        return bindDeployerProperties.isInheritLogging();
    }

    public synchronized int getRandomPort(AppDeploymentRequest request) {
        Set availPorts = new HashSet();
        for (int retryCount = 0; retryCount < 5; ++retryCount) {
            int randomInt = this.getCommandBuilder(request).getPortSuggestion(this.localDeployerProperties);
            try {
                availPorts = SocketUtils.findAvailableTcpPorts((int)5, (int)randomInt, (int)(randomInt + 5));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.debug(e.getMessage() + "Retrying to find available ports.");
                }
                break;
            }
            catch (IllegalStateException e) {
                this.logger.debug(e.getMessage() + "  Retrying to find available ports.");
                continue;
            }
        }
        if (availPorts.isEmpty()) {
            throw new IllegalStateException("Could not find an available TCP port in the range" + this.localDeployerProperties.getPortRange());
        }
        int finalPort = -1;
        this.logger.debug("Available Ports: " + availPorts);
        for (Integer freePort : availPorts) {
            if (usedPorts.contains(freePort)) continue;
            finalPort = freePort;
            usedPorts.add(finalPort);
            break;
        }
        if (finalPort == -1) {
            throw new IllegalStateException("Could not find a free random port range " + this.localDeployerProperties.getPortRange());
        }
        this.logger.debug("Using Port: " + finalPort);
        return finalPort;
    }

    protected Integer isServerPortKeyPresentOnArgs(AppDeploymentRequest request) {
        return request.getCommandlineArguments().stream().filter(argument -> argument.startsWith(SERVER_PORT_KEY_COMMAND_LINE_ARG)).map(argument -> Integer.parseInt(argument.replace(SERVER_PORT_KEY_COMMAND_LINE_ARG, "").trim())).findFirst().orElse(null);
    }

    protected static interface Instance {
        public URL getBaseUrl();

        public Process getProcess();
    }
}

