/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.CommandBuilder;
import org.springframework.util.StringUtils;

public class DockerCommandBuilder
implements CommandBuilder {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String DOCKER_CONTAINER_NAME_KEY = "spring.cloud.deployer.docker.container.name";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String[] buildExecutionCommand(AppDeploymentRequest request, Map<String, String> appInstanceEnv, Optional<Integer> appInstanceNumber) {
        List<String> commands = this.addDockerOptions(request, appInstanceEnv, appInstanceNumber);
        commands.addAll(request.getCommandlineArguments());
        this.logger.debug("Docker Command = " + commands);
        return commands.toArray(new String[0]);
    }

    private List<String> addDockerOptions(AppDeploymentRequest request, Map<String, String> appInstanceEnv, Optional<Integer> appInstanceNumber) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("docker");
        commands.add("run");
        for (String env : appInstanceEnv.keySet()) {
            commands.add("-e");
            commands.add(String.format("%s=%s", env, appInstanceEnv.get(env)));
        }
        this.setPort(commands, appInstanceEnv);
        if (request.getDeploymentProperties().containsKey(DOCKER_CONTAINER_NAME_KEY)) {
            if (appInstanceNumber.isPresent()) {
                commands.add(String.format("--name=%s-%d", request.getDeploymentProperties().get(DOCKER_CONTAINER_NAME_KEY), appInstanceNumber.get()));
            } else {
                commands.add(String.format("--name=%s", request.getDeploymentProperties().get(DOCKER_CONTAINER_NAME_KEY)));
            }
        }
        DockerResource dockerResource = (DockerResource)request.getResource();
        try {
            String dockerImageURI = dockerResource.getURI().toString();
            commands.add(dockerImageURI.substring("docker:".length()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return commands;
    }

    private void setPort(List<String> commands, Map<String, String> appInstanceEnv) {
        String port;
        if (appInstanceEnv.containsKey("SPRING_APPLICATION_JSON")) {
            HashMap properties = new HashMap();
            try {
                properties.putAll((Map)OBJECT_MAPPER.readValue(appInstanceEnv.get("SPRING_APPLICATION_JSON"), (TypeReference)new TypeReference<HashMap<String, Object>>(){}));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to determine server port from SPRING_APPLICATION_JSON");
            }
            port = (String)properties.get("server.port");
        } else {
            port = appInstanceEnv.get("server.port");
        }
        if (StringUtils.hasText((String)port)) {
            commands.add("-p");
            commands.add(String.format("%s:%s", port, port));
        }
    }
}

