/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.CommandBuilder;

public class DockerCommandBuilder
implements CommandBuilder {
    public static final String DOCKER_CONTAINER_NAME_KEY = "spring.cloud.deployer.docker.container.name";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String[] buildExecutionCommand(AppDeploymentRequest request, Map<String, String> args, Optional<Integer> appInstanceNumber) {
        List<String> commands = this.addDockerOptions(request, args, appInstanceNumber);
        this.logger.debug("Docker Command = " + commands);
        return commands.toArray(new String[0]);
    }

    private List<String> addDockerOptions(AppDeploymentRequest request, Map<String, String> args, Optional<Integer> appInstanceNumber) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("docker");
        commands.add("run");
        DockerResource dockerResource = (DockerResource)request.getResource();
        for (Map.Entry<String, String> entry : args.entrySet()) {
            if (entry.getKey().equals("server.port")) {
                commands.add("-p");
                commands.add(String.format("%s:8080", args.get(entry.getKey())));
                continue;
            }
            commands.add("-e");
            commands.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        if (request.getDeploymentProperties().containsKey(DOCKER_CONTAINER_NAME_KEY)) {
            if (appInstanceNumber.isPresent()) {
                commands.add(String.format("--name=%s-%d", request.getDeploymentProperties().get(DOCKER_CONTAINER_NAME_KEY), appInstanceNumber.get()));
            } else {
                commands.add(String.format("--name=%s", request.getDeploymentProperties().get(DOCKER_CONTAINER_NAME_KEY)));
            }
        }
        try {
            String dockerImageURI = dockerResource.getURI().toString();
            commands.add(dockerImageURI.substring("docker:".length()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return commands;
    }
}

